set term postscript mono enhanced eps "Helvetica" 30 dashlength 4

set key below

set nomxtics
set nomytics


set nokey
set yrange [0:*]
set xrange [0:30]

h(x)=a1
set output "SA_MP200-I.eps"
fit h(x) "data_peet" index 0:0 using 1:($4/$3) via a1

set label 1 "Expected value" at 17,0.25
set label 2 "Average = 0.31" at 1,0.55
set arrow 1 from 2,0.52 to 1,a1
plot \
     "data_peet" index 0:0 using 1:($4/$3):(($4/$3)/10) title "New" with errorbars ps 2 pt 6,a1,\
     0.28 ls 1,\
     0.22 ls 1

unset arrow
unset label
#set label 1 "Expected value" at 400,0.25
set label 2 "Average = 0.31" at 450,0.55
set arrow 1 from 600,0.52 to 590,a1
set output "SA_MP200-W.eps"
set xrange [0:800]
set yrange [0:0.6]
set xlabel "Width / nm"
plot \
     "data_peet" index 0:0 using 3:($4/$3):(($4/$3)/10) title "New" with errorbars ps 2 pt 6, a1
unset label
unset arrow


set output "SA_MP200-W2.eps"
set xrange [0:300]
hh(X) = a2
fit hh(x) "data_peet" index 0:0 using 3:($4/$3) via a2
set label 2 "Average = 0.32 " at 170,0.55
set arrow 1 from 240,0.53 to 230,a2
plot \
     "data_peet" index 0:0 using 3:($4/$3):(($4/$3)/10) title "New" with errorbars ps 2 pt 6,\
a2,\
0.22 ls 1,\
0.28 ls 1
unset label
unset arrow











set output "HvW_MP200.eps"
set yrange [0:*]
set xrange [*:*]
set xlabel "Width / nm"
set ylabel "Height / nm" 1.5
plot \
     "data_peet" index 0:0 using 3:4:($4/10) title "New" with errorbars ps 2 pt 6, a1,\
0.22 ls 1,\
0.28 ls 1


set output "SA_MP200-W_BainAus.eps"
set xrange [*:*]
unset arrow
set xlabel "Width / nm"

m(x) = j
fit m(x) "data_peet" index 0:0 using 1:($7/$6) via j

plot \
     "data_peet" index 0:0 using 3:($4/$3):(($4/$3)/10) title "New" with errorbars ps 2 pt 6,\
     "data_peet" index 0:0 using 6:($7/$6):(($7/$6)/10) title "New" with errorbars ps 2 pt 7,\
     m(x)


n(x) = k
fit n(x) "data_peet" index 0:0 using 1:($6) via k

set output "SA_Aus_MP200-W.eps"
plot \
     "data_peet" index 0:0 using 6:($7/$6):(($7/$6)/10) title "New" with errorbars ps 2 pt 7,\
     m(x)


set ylabel "Apparent Shear" 1.5
set key
set output "MP200-BainAus-index.eps"
set xrange [*:*]
unset arrow
set xlabel "Number"
plot \
     "data_peet" index 0:0 using 1:($4/$3):(($4/$3)/10) title "{/Symbol a}_B" with errorbars ps 2 pt 6,\
     "data_peet" index 0:0 using 1:($7/$6):(($7/$6)/10) title "{/Symbol g}" with errorbars ps 2 pt 7
set nokey



set output "MP200-BainAus-Width.eps"
set ylabel "Apparent Shear" 1.5
set xlabel "Width"
set key
set xrange [*:*]
unset arrow
set xlabel "Number"
plot \
     "data_peet" index 0:0 using 3:($4/$3):(($4/$3)/10) title "{/Symbol a}_B" with errorbars ps 2 pt 6,\
     "data_peet" index 0:0 using 6:($7/$6):(($7/$6)/10) title "{/Symbol g}" with errorbars ps 2 pt 7
set nokey










