/*	Take two columns and add them to make an addl column */
/* 	command:
	addl	X1	X2	Y	file1	file2  [alpha beta] */
/*	Takes alpha x1 and beta x2 and adds them. file 1 should have Y cols */
/* 	file2 = output */

#include <math.h>
#include <stdio.h>

int fgetline(s,max,fp)
int	max;
FILE *fp;
char s[];
{
int c, i;

for (i=0; ((i<(max-1)) 
	&& ((c=getc(fp)) != EOF)
	&& (c != '\n')); ++i)
	{
	s[i] = c;
	}
s[i] = '\0';
return	i;
}


main(argc,argv)
        int argc;
        char *argv[];
{
	int i,j,x1,x2,y,max=1000;
	double z,a,b,c,al=1.0,be=1.0;
        char    file1[50],file2[50],line[1000];
	FILE	*fp1,*fp2,*fp3;
  
	if ((argc != 6)&&(argc != 7)&&(argc != 8)) {
		fprintf( stderr, "\nusage: %s X1	X2	Y	file1	file2 [alpha [beta]]\n", argv[0]);
		exit (0);
        }
        strcpy(file1, argv[4]);
        strcpy(file2, argv[5]);
	sscanf(argv[1], "%d", &x1);
	sscanf(argv[2], "%d", &x2);
	sscanf(argv[3], "%d", &y);
	if ((argc >= 7)) 
		sscanf(argv[6], "%lf", &al);
	if ((argc >= 8)) 
		sscanf(argv[7], "%lf", &be);
	if(x1>y || x2>y || x1>x2){
		fprintf( stderr, "\nusage: %s X1	X2	Y	file1	file2 [alpha [beta]]\n", argv[0]);
		fprintf( stderr, "Please ensure X1 <= X2 <= Y\n");
		exit (0);
        }

	fp1=fopen(file1,"r");
	if( !fp1 )fprintf( stderr, "No such file: %s\n", file1 );
	fp2=fopen(file1,"r");
	fp3=fopen(file2,"w");
	if( !fp3 )fprintf( stderr, "No such file: %s\n", file2 );

	for(;;){

		/* read in whole line from 1  without newline */
		
		i=fgetline(line,max,fp1);
		if(i<y)break;

		/*	read in numbers from 2 */
	
		for(j=1;j<=x1;j++)fscanf( fp2, "%lf", &z );
		a=z;
		for(;j<=x2;j++)fscanf( fp2, "%lf", &z );
		b=z;
		for(;j<=y;j++)fscanf( fp2, "%lf", &z );
		c=al*a+be*b;
	
		/*	write without return to 3 */
		/*	write number to 3 with return */
	
		fprintf(fp3,"%s %9g\n",line,c);

	}

	fclose(fp1);
	fclose(fp2);
	fclose(fp3);
}
