/*
/*   This package contains two subroutines.
/*   make_array allocates space for an n-dimensional array.
/*   free_array frees the space, when you are done using the array.
/*
/*   Below is a sample program that allocates a 5x6x7 array of double:
/*
/*
/*
/*	 #include   <array.c>
/*   :
/*   double   ***ARRAY;    /*  declaration of 3-dim. array. */
/*   :
/*   ARRAY = (double ***) make_array( 3, sizeof(double), 5, 6, 7 );
/*   :
/*   ARRAY[0][6][i] = x;   /*  main part of program  */
/*   :
/*   free_array( ARRAY, 3, 5, 6, 7 );
/*   :
/*
/*
/*
/*   So, to summarize the usage:
/*
/*   variable = (type *...) make_array( dimension, sizeof(type), dim1, dim2,.. );
/*   free_array( variable, dimension, dim1, dim2,.. );
*/

#include "r.h"

#ifndef		ARRAY_IS_DEFINED

#define		ARRAY_IS_DEFINED	1

#include <stdio.h>
#include <varargs.h>

extern char *calloc();

#define DEMAND(fact, remark) {\
    if (!(fact)) {\
	fprintf(stderr, "demand not met.\n");\
	fprintf(stderr, "%s\n", remark);\
	abort();\
	exit(1);\
    }\
}

/* VARARG */
void *make_array1(va_alist) va_dcl
{
    va_list ap, app;
    int dim, size, card, i;
    void **p, **q;

    va_start(ap);
    dim = va_arg(ap, int);
    size = va_arg(ap, int);
    app = va_arg(ap, va_list);
    card = va_arg(app, int);
    if (dim == 1) {
        p = (void **) calloc(card , size);
        DEMAND(p, "make_array1: out of memory.");
    } else {
        p = (void **) calloc(card , sizeof(void *));
        DEMAND(p, "make_array1: out of memory.");
        for (q = p, i = 0; i < card; i++)
            *q++ = make_array1(dim-1, size, app);
    }
    va_end(ap);
    return (void *) p;
}
    
/* VARARG */
void *make_array(va_alist) va_dcl
{
    va_list ap;
    int	dim, size;
    void *p;

    va_start(ap);
    dim = va_arg(ap, int);
    DEMAND(dim > 0, "make_array: dimension < 1.");
    size = va_arg(ap, int);
    p = make_array1(dim, size, ap);    
    va_end(ap);
    return p;
}

/* VARARG */
void *free_array1(va_alist) va_dcl
{
    va_list ap, app;
    int dim, card, i;
    void **p, **q;

    va_start(ap);
    p = va_arg(ap, void **);
    dim = va_arg(ap, int);
    app = va_arg(ap, va_list);
    card = va_arg(app, int);
    if (dim == 1)
        free((void *) p);
    else {
        for (q = p, i = 0; i < card; i++)
	    free_array1(*q++, dim-1, app);
	free((void *) p);
    }
    va_end(ap);
}
    
/* VARARG */
void free_array(va_alist) va_dcl
{
    va_list ap;
    void *p;
    int	dim;

    va_start(ap);
    p = va_arg(ap, void *);
    dim = va_arg(ap, int);
    DEMAND(dim > 0, "free_array: dimension < 1.");
    free_array1(p, dim, ap);    
    va_end(ap);
}

#endif

