#include "r.h"
#include "mynr.h"
#include "../inter/bigint.h" 
double  location_function2();
double	f1dim(x,family,dparam,k)
	int	k;	 
	double	x,*dparam;
{
	int	member;
	double	dmember,location,dhouse,delta,dhalf;
	int 	verbose=1,half,odd;

	switch(family){
	case(POLYNOMIAL):case(FOURIER_MIXED):case(6):case(7):
		member	= k-1; 
		break;
	case(RBFCAUCHY):case(TRIANGLE):case(RBFGAUSS):default:
		member	= k; 
		break;
	}
	dmember = (double)(member);
	
	if(verbose==2) printf("family %d, member %d\n",family, member);

	if(member==0) return(1.0);
	else switch(family){
	case(POLYNOMIAL):	/* polynomials */
		return( dpower(x,member) );
		break;
	case(FOURIER_MIXED):	/* fourier set,mixed  */
		half	= (member+1)/2;
		odd	= member%2;
		dhalf	= (double)(half);
		if(odd) return( sin(dhalf*dparam[F_OMEGA]*x+ dparam[F_THETA]) );
		else return( cos(dhalf*dparam[F_OMEGA]*x+ dparam[F_THETA]) );
		break;
	case(RBFCAUCHY):	/* location set -- 1/1+x^2 */
	case(TRIANGLE):	/* location set -- triangle */
	case(RBFGAUSS):	/* location set -- gaussian */
		location = dmember*dparam[F_LOCATIONINTERVAL] + dparam[F_ZERO_RB];
		if((delta=fabs(location-x))>dparam[F_EXTENT])	return(0.0);
		else	
			return( location_function2(family,delta/dparam[F_ICF_WIDTH]));
		break;
	default:
		printf("Invalid family number, func(%d,%d,%g)\n",family,k,x);
		crash("Invalid family number");
		break;
	}
}
double  location_function2(i,x)
        int     i;       
        double  x;
{
	extern	int	control[],**controlpointer;	
	extern	double	aux[],**auxpointer,**inputs,***dmpointer;

        switch(i){
        case(RBFCAUCHY):
                return( 1.0/(1.0 + x*x) ); 
                break;
        case(TRIANGLE):        /* location set -- triangle */
                return( MAX(0.0,1.0 - x) ); 
                break;
        case(RBFGAUSS):        /* location set -- gaussian */
                return( exp( -(x*x)/2.0 ) ); 
                break;
        default:
                printf("Invalid number, location_function2(%d,%g)\n",i,x);
                crash("Invalid number, location_function2");
                break;
        }
}
fkdim(ndimensions,xvector,dparam,family,n)
	int	ndimensions,family,*n,**dparam;
	double	*xvector;
{
	double	dist,dtemp1,answer;
	int	l;

	switch(family){
	case(RBFCAUCHY):
	default:
		for(dist=0.0,l=1;l<=ndimensions;l++){
			dtemp1=(xvector[l]-dparam[l][F_ZERO_RB])/dparam[l][F_ICF_WIDTH]-(double)(n[l]);
			dist+= dtemp1*dtemp1;
		}
		answer = 1.0/(1.0+dist);
		break;
	}
	return(answer);		
}

/* model of what the recursive routines do */

/* for separable functions of x1,x2,x3 */
/* k=1;
for(n1=1;n1<=KK;n1++){
	sofar1=function(1,n1,x1);
	for(n2=1;n2<=KK;n2++){
		sofar2=sofar1*function(2,n2,x2);
		for(n3=1;n3<=KK;n3++){
			sofar3=sofar2*function(3,n3,x3);
			phi[k]=sofar3;
			k++;
		}
	}
} */

/* for non-separable functions of x1,x2,x3 *//*
k=1;
for(n1=1;n1<=KK;n1++){
	for(n2=1;n2<=KK;n2++){
		for(n3=1;n3<=KK;n3++){
			phi[k]=function(x1,x2,x3);
			k++;
		}
	}
}*/

separable_function(type,phiv,phim,k,inv)
		/* type =1 / 2, phiv = vector to put answers in, phim = matrix to put answers in phim[.][k],  inv = input vector */
	int	type,k;
	double	*phiv,**phim,*inv;
{
	int i,element;

	extern	int	control[],**controlpointer;	
	extern	double	aux[],**auxpointer,**inputs,***dmpointer;

	/* set up function values */
	for(i=1;i<=INPUTN;i++)
		make_family(FUNCTIONVALUES[i],inv[i],i);
	element=1;
	recursive_product(1,INPUTN,type,phiv,phim,k,&element,1.0);
	element--;
	if(VERBOSE==2){newline();printf("Recursive routine generated %d values\n",element);}
}

recursive_product(level,totallevel,type,phiv,phim,kkk,kpointer,sofar)
	int	level,totallevel,*kpointer,kkk;
	double	sofar,*phiv,**phim;
{
	double	mysofar;
	int	k;
	extern	int	control[],**controlpointer;	
	extern	double	aux[],**auxpointer,**inputs,***dmpointer;

	if(VERBOSE==2)printf("rl%d:",level);
	for(k=1;k<=KKS[level];k++){
		mysofar = sofar * FUNCTIONVALUES[level][k];
		if(level==totallevel){
			if(type==1)
				phiv[kpointer[0]]=mysofar;
			else	phim[kpointer[0]][kkk]=mysofar;
			kpointer[0]++;
		}
		else
			recursive_product(level+1,totallevel,type,phiv,phim,kkk,kpointer,mysofar);
	}
}


nonseparable_function_recursive(level,totallevel,xvector,type,phiv,phim,kkk,dparam,kpointer,iparam,n)
	int	type,level,totallevel,*kpointer,**iparam,*n,kkk;
	double	*xvector,**dparam,*phiv,**phim;
{
	double	mysofar;
	int	k;
	extern	int	control[],**controlpointer;	
	extern	double	aux[],**auxpointer,**inputs,***dmpointer;
	
	for(n[level]=1;n[level]<=iparam[level][1];n[level]++){
		if(level==totallevel){
			if(type==1)
				phiv[kpointer[0]]=fkdim(totallevel,xvector,dparam,FAMNUM[1],n);
			else	phim[kpointer[0]][kkk]=fkdim(totallevel,xvector,dparam,FAMNUM[1],n);
			kpointer[0]++;
		}
		else
			nonseparable_function_recursive(level+1,totallevel,xvector,type,phiv,phim,kkk,dparam,kpointer,iparam,n);

	}
}


make_family(family,x,i)
	double	*family,x;
	int	i;
{
	int	j;
	extern	int	control[],**controlpointer;	
	extern	double	aux[],**auxpointer,**inputs,***dmpointer;

	switch(FAMNUM[i]){
	case(HERM_POL): /* h polynomials */
		printf("Not implemented \n");
		break;
	case(RBFGAUSS): /* gaussian rbfs */
	case(FOURIER_MIXED): /* mixed fourier */
	case(TRIANGLE): /* triangle */
	case(RBFCAUCHY): /* cauchy */
		for(j=1;j<=KKS[i];j++)
			family[j]=f1dim(x,FAMNUM[i],FP[i],j);
		break;
	default:
		crash("Family number %d problem \n",FAMNUM[i]);
		break;
	}
}



void  makeprior(c,option)
        double  *c;
        int     option;
{
        int i,j,t,element=1;
         
	for(i=1;i<=INPUTN;i++)
		for(j=1;j<=KKS[i];j++){
			t=j/2; /* assuming cos 0 , sin 1 , cos 1 ,... = 1,2,3 */
			FUNCTIONVALUES[i][j]=MAX(1.0,dpower((double)(t),option));
                }
	recursive_product(1,INPUTN,1,c,DUMMYDM,i,&element,1.0);
}
