
/* clib/eig.c */

/* EIGENVECTOR FINDING ROUTINES  */ 
#include "r.h"
#include "mynr.h"

#define TINY 1.0e-6

void	report_eigs(b,a,n,d,verbose) /* b is the matrix, a is the eigenvectors */
	double	**b,**a,*d,verbose;
	int n;
{
     	int i,j,k;
     	double *f,ss;

	f=dvector(1,n);

	printf("\n Normalised Eigenvectors for a real symmetric matrix \n");
	for (i=n;i>=1;i--) {
		ss=0.0;
		if(verbose){printf("Press ENTER to continue...\n");getchar();}
		for (j=1;j<=n;j++) {
			f[j]=0.0;
			for (k=1;k<=n;k++) 
				f[j] += (b[j][k]*a[k][i]);
			ss+=a[j][i]*a[j][i];
		}
		printf("%s %3d %s %10.6f\n", "eigenvalue", i, " =",d[i]);
		if(verbose)printf("%11s %14s %9s\n", "vector","mtrx*vect.","ratio");
		for (j=1;j<=n;j++) {
			if (verbose){
				if (fabs(a[j][i]) < TINY)
					printf("%12.6f %12.6f %12s\n",a[j][i],f[j],"div. by 0");
				else
					printf("%12.6f %12.6f %12.6f\n",a[j][i],f[j],f[j]/a[j][i]);
			}
		}
		printf("Sum of squares = %12.6f\n",ss);
	}
	free_dvector(f,1,n);
}

void	report_eigs2(a,n,d,verbose) /* b is not included, a is the eigenvectors */
	double	**a,*d,verbose;
	int n;
{
     	int i,j,k;
     	double ss;

	printf("\n Normalised Eigenvectors for a real symmetric matrix \n");
	for (i=n;i>=1;i--) {
		ss=0.0;
		if(verbose){printf("Press ENTER to continue...\n");getchar();}
		for (j=1;j<=n;j++) 
			ss+=a[j][i]*a[j][i];
		printf("%s %3d %s %10.6f\n", "eigenvalue", i, " =",d[i]);
		if(verbose)printf("%11s\n", "vector");
		for (j=1;j<=n;j++) {
			printf("%12.6f \n",a[j][i]);
		}
		printf("Sum of squares = %12.6f\n",ss);
	}
}

void	scale_eigs_by_pow_sqrt_lambda(a,d,n,pow)
	double	**a,*d;
	int	pow,n;
{
	double	factor;
	int	i,j;

	for (i=n;i>=1;i--) {
		if(d[i]>0){ 
			factor = dpower(sqrt(d[i]),pow);
			for (j=1;j<=n;j++) a[j][i] *= factor;
		}else{
			printf("Error: non-positive eigenvalue %d %g\n",i,d[i]);
			pause_for_return();
		}
	}
}

void	pos_eigs(d,n,verbose)
	double	*d;
	int	n,verbose;
{
	int	i,count=0;

	for (i=n;i>=1;i--) {
		if(d[i]<0.0){ d[i]=0.0; count++; }
	}
	if(count&&verbose) printf("%d negative eigenvalues set to zero \n",count);
}

#undef TINY

/*
main()
{
        int n,i,j;
	double	**b,**a,*e,*d;
        printf(" Enter n\n");
        inputri(&n);
        randomise(123);
        b=dmatrix(1,n,1,n);
        a=dmatrix(1,n,1,n);

	e=dvector(1,n);
	d=dvector(1,n);

        enterdmatrix(b,1,n,1,n); 
        for (i=1;i<=n;i++)
                for (j=1;j<=n;j++) a[i][j]=b[i][j];
        tred2(a,n,d,e);
        tqli(d,e,n,a);

	report_eigs(b,a,n,d,1);
	scale_eigs_by_pow_sqrt_lambda(a,d,n,1);
	report_eigs(b,a,n,d,1);
}

*/
