#include "r.h"
#include "mynr.h"
#include "../inter/inter.h" /* NB to make inter work, should change this back to 
					inter.h maybe */

double	location_function(i,x)
	int	i;	/* 4 = triangle, 2 = gaussian */ 
	double	x;
{
	extern	double	aux[];
        extern  int     control[];

	switch(i){
	case(5):
		x/= ICF_WIDTH;
		return( 1.0/(1.0 + x*x) ); 
		break;
	case(4):	/* location set -- triangle */
		x/= ICF_WIDTH;
		return( MAX(0.0,1.0 - x) ); 
		break;
	case(2):	/* location set -- gaussian */
		return( exp( -(x*x)/GAUSS_2VAR ) ); /* NB GAUSS_2VAR has been defined to be 2 sigma^2 */
		break;
	default:
		printf("Invalid number, location_function(%d,%g)\n",i,x);
		crash("Invalid number, location_function");
		break;
	}
}

double	location_function2(i,x)
	int	i;	/* 4 = triangle, 2 = gaussian */ 
	double	x;
{
	extern	double	aux[];
        extern  int     control[];

	switch(i){
	case(5):
		return( 1.0/(1.0 + x*x) ); 
		break;
	case(4):	/* location set -- triangle */
		return( MAX(0.0,1.0 - x) ); 
		break;
	case(2):	/* location set -- gaussian */
		return( exp( -(x*x)/2.0 ) ); /* NB GAUSS_2VAR has been defined to be 2 sigma^2 */
		break;
	default:
		printf("Invalid number, location_function2(%d,%g)\n",i,x);
		crash("Invalid number, location_function2");
		break;
	}
}

double	func(i,x)
	int	i;	/* convention: X0Y X=family, Y=family member; X goes in multiples of 200; if Y=0 f=1  */ 
	double	x;
{
	extern	double	aux[];
        extern  int     control[];

	int	family,member;
	double	dmember,location,dhouse,delta,dhalf;
	int 	verbose=1,half,odd;

	family 	= i/200;
	member	= i%200;
	dmember = (double)(member);
	
	if(verbose==2) printf("family %d, member %d\n",family, member);

	if(member==0) return(1.0);
	else switch(family){
	case(1):	/* polynomials */
		return( dpower(x,member) );
		break;
	case(3):	/* fourier set,mixed  */
		half	= (member+1)/2;
		odd	= member%2;
		dhalf	= (double)(half);
		if(odd) return( sin(dhalf*OMEGA0*x+ THETA0) );
		else return( cos(dhalf*OMEGA0*x+ THETA0) );
		break;
	case(6):	/* fourier set,cos  */
		return( cos(dmember*OMEGA0*x+ THETA0) );
		break;
	case(7):	/* fourier set,sin  */
		return( sin(dmember*OMEGA0*x+ THETA0) );
		break;
	case(5):	/* location set -- 1/1+x^2 */
	case(4):	/* location set -- triangle */
	case(2):	/* location set -- gaussian */
	/*	dhouse = (x - ZEROLOCATION)/LOCATIONINTERVAL; */
		location = dmember*LOCATIONINTERVAL + ZEROLOCATION;
		if((delta=fabs(location-x))>HOUSEEXTENT)	return(0.0);
		else	
			return( location_function(family,delta));
		break;
	default:
		printf("Invalid family number, func(%d,%g)\n",i,x);
		crash("Invalid family number");
		break;
	}
}

void fleg(x,pl,nl) /* NB legs are for the interval -1,1 */
double x,pl[];
int nl;
{
	int j;
	double twox,f2,f1,d;

	pl[1]=1.0;
	pl[2]=x;
	if (nl > 2) {
		twox=2.0*x;
		f2=x;
		d=1.0;
		for (j=3;j<=nl;j++) {
			f1=d;
			d += 1.0;
			f2 += twox;
			pl[j]=(f2*pl[j-1]-f1*pl[j-2])/d;
		}
	}
}
void fherp(x,pl,nl,flag) 
	/* my version of the legendre stuff for hermite polynomials */
double x,pl[];
int nl,flag; /* flag =1 incorporates exp(-x^2/2) */ 
{
	int j;
	double twox,f2,f1,d;

	pl[1]=1.0;
	pl[2]=x;
	if(flag){pl[1]*=exp(-x*x/2.0);pl[2]*=exp(-x*x/2.0);}
	if (nl > 2) {
		twox=2.0*x;
		d=1.0;
		for (j=3;j<=nl;j++) {
			pl[j]=(twox*pl[j-1]-d*pl[j-2]);
			d += 1.0;
		}
	}
}
void fherp2(x,pl,nl,flag,extra_int) 
	/* my version of the legendre stuff for hermite polynomials */
double x,**pl;
int nl,flag,extra_int; /* flag =1 incorporates exp(-x^2/2) */ 
{
	int j;
	double twox,f2,f1,d;

	pl[1][extra_int]=1.0;
	pl[2][extra_int]=x;
	if(flag){pl[1][extra_int]*=exp(-x*x/2.0);pl[2][extra_int]*=exp(-x*x/2.0);}
	if (nl > 2) {
		twox=2.0*x;
		d=1.0;
		for (j=3;j<=nl;j++) {
			pl[j][extra_int]=(twox*pl[j-1][extra_int]-d*pl[j-2][extra_int]);
			d += 1.0;
		}
	}
}
void fleg2(x,pl,nl,extra_int)
double x,**pl;
int nl,extra_int;
{
	int j;
	double twox,f2,f1,d;

	pl[1][extra_int]=1.0;
	pl[2][extra_int]=x;
	if (nl > 2) {
		twox=2.0*x;
		f2=x;
		d=1.0;
		for (j=3;j<=nl;j++) {
			f1=d;
			d += 1.0;
			f2 += twox;
			pl[j][extra_int]=(f2*pl[j-1][extra_int]-f1*pl[j-2][extra_int])/d;
		}
	}
}
