/* clib/matrix.c */

#include "r.h"
#include "mynr.h"

double	evaluate_determinant(hessin,n)
	double **hessin;
	int n;
{
	int j,*indx;
	double **a,d;

	indx=ivector(1,n);
	a=dmatrix(1,n,1,n);
	dmatrixfromdmatrix(a,1,n,1,n,hessin);

	ludcmp(a,n,indx,&d); /* from NR page 46 */

	for(j=1;j<=n;j++) d*= a[j][j];

	free_ivector(indx,1,n);
	free_dmatrix(a,1,n,1,n);

	return	d;
}

/* double	luquadratic_form(m,v,n,indx,scratchv)  USE lumatrixproduct */

double	quadratic_form(m,v,lo,hi)
	double **m,*v;
	int lo,hi;
{
	int i,j;
	double d=0.0;

	for(i=lo;i<=hi;i++) 
		for(j=lo;j<=hi;j++) d+= v[i]*m[i][j]*v[j];
	return	d;
}

double	matrixproduct(v1,m,v2,lo,hi)
	double **m,*v1,*v2;
	int lo,hi;
{
	int i,j;
	double d=0.0;

	for(i=lo;i<=hi;i++) 
		for(j=lo;j<=hi;j++) d+= v1[i]*m[i][j]*v2[j];
	return	d;
}

double	lumatrixproduct(v1,m,v2,n,indx) /* NB v2 must be scratchable */
	double **m,*v1,*v2;
	int n,*indx;
{
	int i;
	double d=0.0;

	lubksb(m,n,indx,v2);
	for(i=1;i<=n;i++) 
		d+= v1[i]*v2[i];
	return	d;
}

/* diagproduct(m,lo,hi) already exists in r.c */
/*
double	diagonal_product(m,n)
	double 	**m;
	int 	n;
{
	int 	j;
	double 	d=1.0;

	for(j=1;j<=n;j++) d*= a[j][j];
	return	d;
}
*/

double	trace(m,n)
	double **m;
	int n;
{
	int j;	
	double d=0.0;

	for(j=1;j<=n;j++) d+= m[j][j];
	return	d;
}

void	find_eigs(m,n,l)
	double **m,*l;
	int n;
{
	int j;	
	double d=0.0,*e;

	e=dvector(1,n);
	tred2(m,n,l,e);
        tqli(l,e,n,m);

	free_dvector(e,1,n);	
}

int	clip_eigs(d,n,min)
	double	*d,min;
	int	n;
{
	int	i,count=0;

	for (i=n;i>=1;i--) {
		if(d[i]<min){ d[i]=min; count++; }
	}
	return	count;
}

void	det_and_tr_from_eigs(d,n,alt_det_p,alt_tr_p)
	double	*d,*alt_det_p,*alt_tr_p;
	int	n;
{
	int	i,count;

	alt_det_p[0]=1.0;alt_tr_p[0]=0.0;
	for (i=n;i>=1;i--) {
		alt_det_p[0] /= d[i];
		alt_tr_p[0] += 1.0/d[i];
	}
}


/* Makes diagonal decomposition of the matrix */
#define	float	double
#define	free_vector free_dvector 
#define	vector dvector 
#include "ludcmp.c"
#include "lubksb.c"
#include "tred2.c"
#include "tqli.c"
#undef	float
#undef	free_vector
#undef	vector 

double	invert_dmatrix(m,n,inverse) /* returns the determinant of m too */ 
	double 	**m,**inverse;
	int n;
{
	int	*indx,i,j;
	double 	**a,d=1.0,*col; 

	col=dvector(1,n);
	indx=ivector(1,n);
	a=dmatrix(1,n,1,n);
	dmatrixfromdmatrix(a,1,n,1,n,m);

	ludcmp(a,n,indx,&d); /* from NR page 46 */

	for(j=1;j<=n;j++) d*= a[j][j];

	for(j=1;j<=n;j++) {
		for(i=1;i<=n;i++) col[i]=0.0;
		col[j]=1.0;
		lubksb(a,n,indx,col);
		for(i=1;i<=n;i++) inverse[i][j]=col[i];
	}

	free_dvector(col,1,n);
	free_ivector(indx,1,n);
	free_dmatrix(a,1,n,1,n);

	return	d;
}

double	invert_dmatrixfamily(mp) /* returns the determinant of m too */ 
     dmatrix_family *mp;
{
  int n;
  int i,j;
  double d=1.0,*col; 

  n=mp->n;
  col=dvector(1,n);
  dmatrixfromdmatrix(mp->lu,1,n,1,n,mp->m);
  
  ludcmp(mp->lu,n,mp->indx,&d); /* from NR page 46 */

  for(j=1;j<=n;j++) d*= mp->lu[j][j];
  
  for(j=1;j<=n;j++) {
    for(i=1;i<=n;i++) col[i]=0.0;
    col[j]=1.0;
    lubksb(mp->lu,n,mp->indx,col);
    for(i=1;i<=n;i++) mp->in[i][j]=col[i];
  }

  free_dvector(col,1,n);
  mp->det = d;
  printf("%f\n",d);
  printf("%f\n",mp->det);
  return d;
}

/* this is a silly idea */
double	luinvert_dmatrix(m,n,inverse,lu,indx,col) /* returns the determinant of m too */ 
	double 	**m,**inverse,**lu,*col;
	int n,*indx;
{
	int	i,j;
	double 	d=1.0;

	/* assume col=dvector(1,n); scratch vector, supplied */
	/* assume indx=ivector(1,n); */
	/* assume lu=dmatrix(1,n,1,n); */
	dmatrixfromdmatrix(lu,1,n,1,n,m);

	ludcmp(lu,n,indx,&d); /* from NR page 46 */

	for(j=1;j<=n;j++) d*= lu[j][j];

	for(j=1;j<=n;j++) {
		for(i=1;i<=n;i++) col[i]=0.0;
		col[j]=1.0;
		lubksb(lu,n,indx,col);
		for(i=1;i<=n;i++) inverse[i][j]=col[i];
	}


	return	d;
}

void	symmetrise_dmatrix(m,n)
	double 	**m;
	int n;
{
	int	i,j;

	for(j=2;j<=n;j++) 
		for(i=1;i<j;i++) 
			m[i][j]=m[j][i]=0.5*(m[i][j]+m[j][i]);
}
