/*
/*  void	SKIP_TO_END( fp )
/*	FILE		*fp;
/*
/*  int		NEW_SEED( mode )
/*	int		mode;
/*
/*  double	d_random;
/*
/*  void	PRCR
/*
/*  void	PRCR_ERR;
/*
/*
/*  SKIP_TO_END advances the fp past the next <CR>.
/*
/*  NEW_SEED gives a new seed to srandom, using either the system
/*	clock (mode = USE_TIME) or the process number of the
/*	program being executed (mode = USE_PID).
/*
/*  d_random  returns a random value on [0,1).
/*  PRCR prints <CR> to stdout.
/*  PRCR_ERR prints <CR> to stderr.
/*
/*  can_file_be_opened()  returns 0 if open() returned an error,
/*  else 1 is returned.
/*    If the filename starts with a '/' it is taken as pathname,
/*  else $PWD (working directory) is added in front of the filename.
*/

/************************************************/

#ifndef		SUNDRY_GOODIES_IS_DEFINED

#define		SUNDRY_GOODIES_IS_DEFINED	1

#include	<sys/types.h>
#include	<sys/timeb.h>

#include "r.h"
#include	</home/mackoj.h> /* added by me for makefile purposes */

/* #define		PRCR		printf( "\n" )
/* #define		PRCR_ERR	fprintf( stderr, "\n" )
/* #define		d_random	((double)( random() % 65536) / 65536.0 )
 DJCM removed for makefile reasons */
/************************************************/

void	SKIP_TO_END( fp )
	FILE	*fp;
{
	int	ch;

	while( ((ch = (int) getc( fp )) != 10) && (ch != EOF));
}

/*****************   NEW_SEED   *****************/

#define		USE_TIME	0
#define		USE_PID		1

int	NEW_SEED( mode )
	int	mode;
{
	int		Seed, i;
	int		ms;
	long		sec;
	long		loop, count;
	struct timeb	*tp, tt;

	if (mode == USE_TIME)   {
		tp = (struct timeb *) malloc( 1*sizeof(struct timeb) );
		ftime( tp );  tt = *tp;
		sec = (long) tt.time;  ms = (int) tt.millitm;
		Seed = sec*50 + ms/20;
	} else if (mode == USE_PID)
		Seed = getpid();
	else   {
		fprintf( stderr, "NEW_SEED:  Bad mode choice: %d\n\n", mode );
		exit (0);
	}

	srandom( Seed );
	return (Seed);
}

/*************   can_file_be_opened   *************/

#include	<stdio.h>
#include	<fcntl.h>

int	can_file_be_opened( filename )
	char	*filename;
{
	int	exists, fp;
	char	pathname[199];

	if ( filename[0] == '/' )
		strcpy( pathname, filename );
	else   {
		strcpy( pathname, getenv("PWD" ));
		strcat( pathname, "/" );
		strcat( pathname, filename );
	}
	fp = open( pathname, O_RDONLY );
	if (!(exists = (fp != -1)))
		fprintf (stderr, "\n***   %s does not exist  ***\n\n", filename);
	close( fp );
	return( exists );
}

#endif

