#include <math.h>
#include <stdio.h>
#include <stdlib.h>
/*  Maximum number of lines is 10000 and number of models is 80.  */
/*  This program combines the predictions of more than one models */
/*  accorging to REF.                                             */
/*  Thomas Sourmail, Cambridge University, 01/2000                */

int main(int argc,char *argv[])
{
  int cnt=0,i=0;
  int no_of_models,no_of_lines;
  char filename[100];
  float average[10000][80],stdev[10000][80],dump;
  float sum_average[10000],sum_dev[10000],ave_var[10000],varcom[10000];
  FILE *ifp;

  if (argc != 4){
    printf("\n\n%s%s%s","Usage:",argv[0]," number of models, number of lines, directory for the out files\n");
    exit(1);
  }

  no_of_models=atoi(argv[1]);
  no_of_lines=atoi(argv[2]);

  for (i=1;i<=7000; ++i){
    sum_average[i]=0;
    sum_dev[i]=0;
    ave_var[i]=0;
    varcom[i]=0;
  }

  while (cnt++ < no_of_models) {
    sprintf(filename,"./%s/out%d",argv[3],cnt);
    ifp=fopen(filename,"r");
    for (i=1 ; i<=no_of_lines ; ++i){
      fscanf(ifp,"%f",&average[i][cnt]);
      fscanf(ifp,"%f",&stdev[i][cnt]);
      fscanf(ifp,"%f",&dump);
      fscanf(ifp,"%f",&dump);
      sum_average[i] += average[i][cnt];
      stdev[i][cnt] *= stdev[i][cnt];
      sum_dev[i] += stdev[i][cnt];
    }
    fclose(ifp);
  }

  for(i=1 ; i<=no_of_lines ; ++i){
  sum_average[i] /= no_of_models;
  sum_dev[i] /= no_of_models;
  }

  ifp=fopen("./com.dat","w");
  
  for (i=1 ; i<=no_of_lines ; ++i){
    for (cnt=1 ; cnt<=no_of_models ; ++cnt)
      ave_var[i] += pow((sum_average[i]-average[i][cnt]),2);
    ave_var[i] /= no_of_models;
    varcom[i] = (sum_dev[i]+ave_var[i]);
    varcom[i] = sqrt(varcom[i]);

/*      printf("%f %f %f %f\n",sum_average[i],varcom[i],sum_average[i]-varcom[i],sum_average[i]+varcom[i]); */

    fprintf(ifp,"%f %f %f %f\n",sum_average[i],varcom[i],sum_average[i]-varcom[i],sum_average[i]+varcom[i]);
  }
  return 0 ;
}



