       PROGRAM martensite
C H. K. D. H. Bhadeshia, February 2013
C Finland conference paper
C To calculate fraction of transformation when
C  two martensitic reactions with different MS temperatures
C  occur simultaneously
       IMPLICIT NONE
       DOUBLE PRECISION CHI,MS(1000),T,F(1000),VNORM(1000),DELTAT,FTOT
       INTEGER I,IMAX,J
C dataset must be arranged in order of descending MS temperatures
C VNORM represents the fraction of austenite
       
       T=501.0
       DELTAT=1.0
       I=0
       IMAX=2
       CHI=-0.011D+00
       
       DO I=1,1000
         F(I)=0.0
       END DO

       DO I=1,IMAX
        READ(*,*) MS(I),VNORM(I)
       END DO
       
       DO I=1,1000,1
        T=T-DELTAT
       
          IF(T .GE. MS(2) .AND. T .LE. MS(1))THEN
           CALL KM(CHI,MS(1),T,F(1))
           F(2)=0.0
           FTOT=F(1)
          ELSE
           IF(T .LE. MS(1) .AND. T .LE. MS(2))THEN
           F(1)=F(1)-CHI*(1.0D+00-FTOT)*DELTAT
           F(2)=F(2)-CHI*(1.0D+00-FTOT)*DELTAT
           FTOT=F(1)+F(2)
           ENDIF
          ENDIF
          WRITE(*,10)FTOT,F(1),F(2),T
C

       IF(T .LE. 30.0)STOP       
       END DO
       
       
10       FORMAT(F20.3,2F10.3,F10.0)
222    STOP
       END

C------------------------------------------------------------------
       SUBROUTINE KM(CHI,MS,T,F)
       DOUBLE PRECISION CHI,MS,T,F
C F is the fraction of martensite
C T is the temperature
C MS is the martensite-start temperature
C chi is the Koistinen and Marburger constant (-0.011 typically)
          F=1.0D+00 - DEXP(CHI*(MS-T))
C       WRITE(*,*)chi,ms,T,F
       RETURN
       END