       PROGRAM martensite
C H. K. D. H. Bhadeshia, February 2013
C Finland conference paper
C To calculate fraction of transformation when
C  IMAX martensitic reactions with different MS temperatures
C  occur simultaneously
       IMPLICIT NONE
       DOUBLE PRECISION CHI,MS(1000),T,F(1000),VNORM(1000),DELTAT,FTOT
       INTEGER I,IMAX,J
C dataset must be arranged in order of descending MS temperatures
C VNORM represents the fraction of austenite
       
       T=501.0
       DELTAT=1.0
       I=0
       IMAX=24
       CHI=-0.011D+00
       
       DO I=1,1000
         F(I)=0.0
       END DO

       DO I=1,IMAX
        READ(*,*) MS(I)
       END DO
       
       DO I=1,1000,1
        T=T-DELTAT
       
          IF(T .GE. MS(2) .AND. T .LE. MS(1))THEN
           CALL KM(CHI,MS(1),T,F(1))
           F(2)=0.0
           FTOT=F(1)
          ELSE
           IF(T .LE. MS(1) .AND. T .LE. MS(2))THEN
           F(1)=F(1)-CHI*(1.0D+00-FTOT)*DELTAT
            DO J=2,IMAX
            IF(T .LE. MS(J))THEN
           F(J)=F(J)-CHI*(1.0D+00-FTOT)*DELTAT
            ELSE
            F(J)=0.0
            ENDIF
            END DO
            FTOT=0.0
           DO J=1,IMAX
           FTOT=FTOT+F(J)
           END DO
           ENDIF
          ENDIF
          WRITE(*,10)T, FTOT,F(1),F(2),F(3),F(4),F(5),F(6),
&         F(7),F(8),F(9),F(10),F(11),F(12),F(13),F(14),F(15),
&         F(16),F(17),F(18),F(19),F(20),F(21),F(22),F(23),F(24)
C

       IF(T .LE. 30.0)STOP
       IF(FTOT .gt. 0.99)STOP
       END DO
       
       
10       FORMAT(F5.0,F5.2,F15.2,23F5.2)
222    STOP
       END

C------------------------------------------------------------------
       SUBROUTINE KM(CHI,MS,T,F)
       DOUBLE PRECISION CHI,MS,T,F
C F is the fraction of martensite
C T is the temperature
C MS is the martensite-start temperature
C chi is the Koistinen and Marburger constant (-0.011 typically)
          F=1.0D+00 - DEXP(CHI*(MS-T))
C       WRITE(*,*)chi,ms,T,F
       RETURN
       END