       PROGRAM martensite
C H. K. D. H. Bhadeshia, February 2013
C Finland conference paper
C To calculate fraction of transformation when
C  IMAX martensitic reactions with different MS temperatures
C  occur simultaneously
C IVAR is variant number
C J1 is the number of different kinds of martensite
C GMECH mechanical driving force in J/mol. Positive elevated M_S
C MS0 stress-free martensite-start temperature
C 0.1748 is the variation in MS per J/mol of GMECH
C dataset must be in descending order of MS
       IMPLICIT NONE
       DOUBLE PRECISION CHI,MS(15000),T,F(15000),DELTAT,FTOT,
&      GMECH,MS0,DF(15000),VNORM       
       INTEGER I,IMAX,J,J1,IVAR
C dataset must be arranged in order of descending MS temperatures
C VNORM represents the fraction of austenite

       OPEN(UNIT=2, FILE="FRACTION")       
       OPEN(UNIT=3, FILE="EVOLVE") 
       

       FTOT=0.0
       IMAX=2400
       CHI=-0.011D+00
       MS0=140.0
       T=MS0+30.0
       DELTAT=0.0001
       
       DO I=1,IMAX
         F(I)=0.0
         MS(I)=0.0
       END DO

       DO I=1,IMAX
        READ(*,*) IVAR,GMECH
        MS(I)=MS0+0.1748*GMECH
C        write(*,10)MS(I)
       END DO
       
       DO I=1,1000000,1
        T=T-DELTAT
       
          IF(T .GE. MS(2) .AND. T .LE. MS(1))THEN
           CALL KM(CHI,MS(1),T,F(1))
           FTOT=F(1)
          ELSE
           IF(T .LE. MS(1) .AND. T .LE. MS(2))THEN
              F(1)=F(1)-CHI*(1.0D+00-FTOT)*DELTAT
              
               DO J=2,IMAX
                IF(T .LE. MS(J))THEN
                  F(J)=F(J)-CHI*(1.0D+00-FTOT)*DELTAT
                 ELSE
                  F(J)=0.0
                ENDIF
               END DO
               FTOT=0.0
               DO J=1,IMAX
                 FTOT=FTOT+F(J)
                WRITE(3,12)MS(J),F(J)
               END DO

           ENDIF
          ENDIF
          IF(FTOT .GT. 0.0) THEN
            WRITE(*,10)T, FTOT,F(1),F(2),F(3),F(4),F(5),F(6),
&            F(7),F(8),F(9),F(10),F(11),F(12),F(13),F(14),F(15),
&            F(16),F(17),F(18),F(19),F(20),F(21),F(22),F(23),F(24)
            WRITE(2,11)T,FTOT
          ENDIF
C

       IF(T .LE. 30.0)STOP
       IF(FTOT .gt. 0.99)STOP
       END DO
       
       
10       FORMAT(F10.3,F8.2,F15.2,23F5.2)
11       FORMAT(F10.3,F8.2)
12       FORMAT(F10.3,F8.2)
222    STOP
       END

C------------------------------------------------------------------
       SUBROUTINE KM(CHI,MS,T,F)
       DOUBLE PRECISION CHI,MS,T,F
C F is the fraction of martensite
C T is the temperature
C MS is the martensite-start temperature
C chi is the Koistinen and Marburger constant (-0.011 typically)
          F=1.0D+00 - DEXP(CHI*(MS-T))
C       WRITE(*,*)chi,ms,T,F
       RETURN
       END