       PROGRAM martensite
C H. K. D. H. Bhadeshia, February 2013
C Finland conference paper
C To calculate fraction of transformation when
C  IMAX martensitic reactions with different MS temperatures
C  occur simultaneously
C IVAR is variant number
C IVAR2 is 24
C J1 is the number of different kinds of martensite
C GMECH mechanical driving force in J/mol. Positive elevated M_S
C MS0 stress-free martensite-start temperature
C 0.1748 is the variation in MS per J/mol of GMECH
C dataset must be in descending order of MS
C IGRAIN is number of austenite grains
       IMPLICIT NONE
       DOUBLE PRECISION CHI,MS(600,24),T,F(600,24),DELTAT,FTOT,
&      GMECH,MS0,VNORM(600),VTOT       
       INTEGER I,IMAX,J,J1,IVAR,IGRAIN,K,IVAR2,I2
C dataset must be arranged in order of descending MS temperatures
C VNORM represents the fraction of austenite

       OPEN(UNIT=2, FILE="FRACTION")       
       OPEN(UNIT=3, FILE="EVOLVE") 
       
       IGRAIN=400
       IVAR2=24
       FTOT=0.0
       IMAX=2400
       CHI=-0.011D+00
       MS0=140.0
       T=MS0+30.0
       DELTAT=0.1
       VTOT=0.0
       
       DO I=1,IGRAIN
         DO K=1,IVAR2
          F(I,K)=0.0
          MS(I,K)=0.0
         END DO
       END DO



       DO I=1,IGRAIN
        DO K=1,IVAR2
         READ(*,*) IVAR,GMECH
         MS(I,K)=MS0+0.1748*GMECH
        END DO
       END DO
       
       

        
         DO I=1,IGRAIN
            do I2=1,1000000,1
             T=T-DELTAT
             IF(T .LT. 30.0)GO TO 14
             CALL VAR(T,MS,I,K,F,FTOT,CHI,DELTAT)

          
          
          IF(FTOT .GT. 0.0) THEN
            WRITE(*,10)T, FTOT,F(I,1),F(I,2),F(I,3),F(I,4),
&            F(I,5),F(I,6),
&            F(I,7),F(I,8),F(I,9),F(I,10),F(I,11),F(I,12),
&            F(I,13),F(I,14),F(I,15),
&            F(I,16),F(I,17),F(I,18),F(I,19),F(I,20),
&            F(I,21),F(I,22),F(I,23),F(I,24)
            WRITE(2,11)T,FTOT
          ENDIF
C


C end K loop (variants)
             end do
14           VNORM(I)=FTOT/IGRAIN
             VTOT=VTOT+VNORM(I)
             WRITE(3,12)I, VNORM(I)
C end I loop (grains)             
             END DO


       
       
10       FORMAT(F10.3,F8.2,F15.2,23F5.2)
11       FORMAT(F10.3,F8.2)
12       FORMAT(I7,D12.4)

222    STOP
       END

C------------------------------------------------------------------
       SUBROUTINE VAR(T,MS,I,K,F,FTOT,CHI,DELTAT)
       DOUBLE PRECISION MS(600,24),T,F(600,24),CHI,DELTAT,FTOT
       INTEGER I,K,J
        
          IF(T .GE. MS(I,2) .AND. T .LE. MS(I,1))THEN
           CALL KM(CHI,MS(I,1),T,F(I,1))
           FTOT=F(I,1)
          ELSE
           IF(T .LE. MS(I,1) .AND. T .LE. MS(I,2))THEN
              F(I,1)=F(I,1)-CHI*(1.0D+00-FTOT)*DELTAT
              
               DO J=2,24
                IF(T .LE. MS(I,J))THEN
                  F(I,J)=F(I,J)-CHI*(1.0D+00-FTOT)*DELTAT
                 ELSE
                  F(I,J)=0.0
                ENDIF
               END DO
               FTOT=0.0
               DO J=1,24
                 FTOT=FTOT+F(I,J)
                 
               END DO

           ENDIF
          ENDIF

       RETURN
       END

C------------------------------------------------------------------
       SUBROUTINE KM(CHI,MS,T,F)
       DOUBLE PRECISION CHI,MS,T,F
C F is the fraction of martensite
C T is the temperature
C MS is the martensite-start temperature
C chi is the Koistinen and Marburger constant (-0.011 typically)
          F=1.0D+00 - DEXP(CHI*(MS-T))
C       WRITE(*,*)chi,ms,T,F
       RETURN
       END