! Copyright H. K. D. H. Bhadeshia, 2014
!           University of Cambridge
!           Department of Materials Science and Metallurgy
!           27 Charles Babbage Road, Cambridge CB3 0FS, U.K.
!
! To calculate how much carbon can be accommodated at dislocations
!  according to the free volume provided by the dislocations
!

! AC is lattice parameter of cubic ferrite in metres
! B is the Burgers vector in bcc iron, in metres
! DELTAVC is the volume change when one carbon atom is inserted 
!  in unit cell of bcc iron
! R0 inner cut off radius of dislocation strain field
! R outer cut off radius of dislocation strain field
! RHO dislocation density in units of 1/m^2
! GAMMA volume change due to dislocation, per atomic volume OMEGA
! NVC number of carbon atoms per unit volume of ferrite
!   that do not cause a lattice parameter change 
! AV Avogadro's number
! AC atomic percent of carbon
!
! 
      IMPLICIT NONE
      INTEGER I,J,K
      DOUBLE PRECISION GAMMA, R, R0, OMEGA, B, M, RHO, VBAR, NVC
      DOUBLE PRECISION DELTAVC, AC, XALPHASS, WC, AV, RHO1
      
      M=2.7
      AC= 2.867D-10
      GAMMA=0.38
      AV=6.023D23
      VBAR=AV*(AC**3)/2.0
      
      B=DSQRT(3*AC**2)/2.0
      DELTAVC=0.78D-29
      OMEGA=4*B**3/(3**1.5)
      write(*,*) 'omega/deltavc ',OMEGA/DELTAVC
      R0=B
      RHO1=1D16

      

      


      WRITE(*,*)'  RHO / m^{-2}       R / m       wt% C     at\%'
      DO I=1,10
C      RHO=RHO1/(I*1.0)
      RHO=6.4d15
C      R=M*1.0/DSQRT(RHO)
      R=80d-9
      NVC=(OMEGA*GAMMA*DLOG(R/R0)*RHO)/(DELTAVC*B)
      WC=100.0*(12.011*NVC)/(55.847/OMEGA)
      AC=WC*56/12
      
      WRITE(*,1) RHO,R, WC, AC
      END DO
1     FORMAT(2D14.4,F12.4, d12.4, d12.4)
	

      
      
      STOP
      END