! Carbon Content - X-ray
	program C_Content
      implicit none
        real(8) :: x_C, x_Si, x_Mn, x_Ni, x_Mo, x_Cr, x_V
        real(8) :: x_Ti, x_Fe, x_Co, x_Cu, x_Nb, x_Al, x_W
        real(8) :: w_C, w_Si, w_Mn, w_Ni, w_Mo, w_Cr, w_V
        real(8) :: w_Ti, w_Fe, w_Co, w_Cu, w_Nb, w_Al, w_W
        real(8) :: a_latt_ferr, a_latt_aust, a_calc !in Angstron
        real(8) :: diff, k1, k2, k3
        real(8) :: y_C, y_Si, y_Mn, y_Ni, y_Mo, y_Cr, y_V
        real(8) :: y_Ti, y_Fe, y_Co, y_Cu, y_Nb, y_Al, y_W
        real(8) :: Total, x_C_ferr, x_C_aust
        real(8) :: comp, w_C_ferr, w_C_aust
        real(8) :: at_mas, at_mass, at_mtotal
        real(8), parameter :: a_Fe=2.8664 !in Å
! Read chemical composition
        namelist / chemical/ w_C, w_Si, w_Mn, w_Ni, w_Mo, w_Cr, w_V, w_Ti, w_Co, w_Cu, w_Nb, w_Al, w_W
        namelist / lattice/ a_latt_ferr, a_latt_aust
        open (unit=1, file='in.txt', status='old')
        read(1, chemical)
        read(1, lattice)
        close(1)
! wt% to mole fraction
        w_Fe=100-w_C-w_Si-w_Mn-w_Ni-w_Mo-w_Cr-w_V-w_Ti-w_Co-w_Cu-w_Nb-w_Al-w_W
        y_C=w_C/12.011
        y_Si=w_Si/28.086
        y_Mn=w_Mn/54.938
        y_Ni=w_Ni/58.693
        y_Mo=w_Mo/95.94
        y_Cr=w_Cr/51.996
        y_V=w_V/50.942
        y_Ti=w_Ti/47.867
        y_Fe=w_Fe/55.845
        y_Co=w_Co/58.933
        y_Cu=w_Cu/63.546
        y_Nb=w_Nb/92.906
        y_Al=w_Al/26.982
        y_W=w_W/183.84
        Total=y_C+y_Si+y_Mn+y_Ni+y_Mo+y_Cr+y_V+y_Ti+y_Fe+y_Co+y_Cu+y_Nb+y_Al+y_W
        x_Si=y_Si/Total
        x_Mn=y_Mn/Total
        x_Ni=y_Ni/Total
        x_Mo=y_Mo/Total
        x_Cr=y_Cr/Total
        x_V=y_V/Total
        x_Ti=y_Ti/Total
        x_Fe=y_Fe/Total
        x_Co=y_Co/Total
        x_Cu=y_Cu/Total
        x_Nb=y_Nb/Total
        x_Al=y_Al/Total
        x_W=y_W/Total
    diff=1.0
    x_C=0.000000
    if (a_latt_aust.gt.0.0000) then
        goto 25
        else
    endif
25      comp=0.00095*w_Mn+0.0006*w_Cr-0.0002*w_Ni+0.0056*w_Al+0.0031*w_Mo+0.0018*w_V
        w_C_aust=(a_latt_aust-3.5780-comp)/0.033
        x_C_aust=(w_C_aust/12.01)/Total*100
    if (a_latt_ferr.gt.0.000) then
        goto 40
        else
    endif
40  if (diff.gt.0.00000001) then
        k1=(a_Fe-0.279*x_C)*(a_Fe-0.279*x_C)
        k2=a_Fe+2.496*x_C
        k3=-0.03*x_Si+0.06*x_Mn+0.07*x_Ni+0.31*x_Mo+0.05*x_Cr+0.096*x_V
        a_calc=a_Fe+(k1*k2-a_Fe*a_Fe*a_Fe)/(3*a_Fe*a_Fe)+k3
        diff=a_latt_ferr-a_calc
        x_C=x_C+0.0000001
    goto 40
    else
        x_C_ferr=x_C
        at_mas=x_C_ferr*12.01+x_Si*28.09+x_Mn*54.95+x_Ni*58.71+x_Mo*95.94+x_Cr*52+x_V*50.94
        at_mass=x_Ti*47.9+x_Fe*55.85+x_Co*58.93+x_Cu*63.55+x_Nb*92.91+x_Al*26.98+x_W*183.84
        at_mtotal=at_mas+at_mass
        w_C_ferr=x_C_ferr*12.01/at_mtotal*100
        open (unit=11, file='lattice.txt', status='unknown')
        write(11, '(A)') 'Carbon content in the austenite'
        write(11, '(A,F8.4,5x,A,F8.4)') 'C(wt%)aust=',w_C_aust,'C(at%)aust=',x_C_aust
        write(11, '(A)') ' '
        write(11, '(A)') 'Carbon content in the ferrite'
        write(11, '(A,F8.4,5x,A,F8.4)') 'C(wt%)(ferr)=',w_C_ferr,'C(at%)(ferr)=',x_C_ferr*100
    endif



      end program C_Content
