/* backprop/generate.c */
/* generate44 reads in a weight file (with error bar matrix) 
   and generates outputs and residuals and sensitivities to inputs 
   and error bars as specified in the spec file */
#include "src/r.h"
#include "src/mynr.h"
#include "backprop4.h"
/* 
   14 5 93    generate44 can also do random network generation
   with command line sigma_w's, etc., for sampling from priors.  

   24 1 94: adding generate-sensitivities-to-inputs for mng10
   16 2 94: finished same, using res file.
   16 2 94: iofile becomes a target-vs-output file  
   24 2 94: Use LU decomposition for error bars. 

   This program tested using
generate33 backspec6 8 w/_weights 1

Future tasks: Mean marginal information gain (from generate5)
*/

FILE    *fopen(); 

/* external variables */

int	control[200],**controlpointer,***wn;
double	aux[200],**auxpointer,**inputs,**targets;	
char	files[50][50];
float **image;

void main(argc, argv)
     int argc;
     char *argv[];
{
  extern	int	control[],**controlpointer,***wn;	
  extern	double	aux[],**auxpointer,**inputs,**targets;
  extern float **image;
  char 	specfile[50];  

  int 	i,
  j,k,iter;
  int 	*luhessinindx,verbose=1,t;
  long	wseed;
  double	*scratchv,**luhessin; /* ,*weight */
  
  FILE    *fp1,*fp2,*fp3,*fp4;
	
  auxpointer = (double **) malloc((unsigned) (20)*sizeof(double*));
  controlpointer = (int **) malloc((unsigned) (20)*sizeof(int*));
  image = (float **) malloc((unsigned) (10)*sizeof(float*));
  VERBOSE = verbose;
  
  if (argc != 2 && argc!=4  && argc!=5 && argc!=7) {
    fprintf( stderr, "Program to generate outputs from a specified network or from a random network");
    fprintf( stderr, "\nusage: %s Specfile [Hidden [Weights_file [LUhessin] ] ] OR [Seed Sigma_in Sigma_b Sigma_out] ]\n", argv[0]);
    exit (0);
  }
  
  strcpy(specfile, argv[1]);
  
  fprintf( stderr, "-----------------------------------------------\n" );
  fprintf( stderr, "    	 Generating outputs using network \n" );
  fprintf( stderr, "-----------------------------------------------\n" );
  
  if(argc>=4){
    sscanf(argv[2], "%d", &HIDDENN);
  }
  else	HIDDENN=0;
  
  read_spec(specfile,&wseed); 
  
  if(argc==4 || argc==5 )
    {
      WEIGHTS_FROM_FILE = 1;
      strcpy(WEIGHTFILE, argv[3]);
      if(argc==5)
	{
	  if(GEN_BARS==0) GEN_BARS=1;
	  strcpy(LUHESSININ, argv[4]);
	}
  } 
  else if (argc==7) 
    {
      sscanf(argv[3], "%ld", &wseed);
      for(i=1;i<=MIN(3,REGS);i++){
	sscanf( argv[3+i], "%lf", &DTEMP1 );
	V_LOGS_W[i]=log(DTEMP1);
      }	
    }
  
  /* load the data */
  
  if(!DATA_FROM_IM){
    readindmatrix(inputs,1,NUMBER_DATA,1,INPUTN,INPUTFILE);
  } /* else images have already been read in read spec */
  else { /* To confine attention to one image only */
    NUMBER_DATA = TRAIN_NUMBER;
    active_image(1);
  }
  if(GEN_WRITE_RES || GEN_WRITE2){ /* targets will be needed */
    if(!DATA_FROM_IM){
      readindmatrix(targets,1,NUMBER_DATA,1,OUTPUTN,TARGETFILE);
    }
    else {
      active_image(1);
      image_to_targets( TRAIN_IM_T , TRAIN_PATCH , 1 , TRAIN_NUMBER ) ; 
    }
  }
  
  if(WEIGHTS_FROM_FILE) { 
    switch(WEIGHTS_FROM_FILE){
    case(1):
    case(2):
    case(3):
      readindvector(PARAM+1,WEIGHTNUMBER,WEIGHTFILE);
      break;
    default: printf("WEIGHTS_FROM_FILE error \n"); break;
    }
  }
  else{
    randomise(wseed);
    for(i=1;i<=WEIGHTNUMBER;i++) {
      PARAM[i]= gaussian( V_SIGMA_W( REGCLASS[i] ) ); 
      /* initialise weights to random gaussian values */ 
      /* NB sigma_w are used instead of Random_weight_size */
      if (VERBOSE>1) printf("%5g ",PARAM[i]) ;
    }
    if (VERBOSE>1) printf("\n");
  }
  
  if(GEN_BARS)GEN_WRITE1=1;
  if(GEN_WRITE1)
    {
      printf("outputs will be written to %s\n",OUTPUTFILE);
      if(GEN_BARS){
	printf("with error bars\n");
	luhessin = dmatrix(1,WEIGHTNUMBER ,1,WEIGHTNUMBER);
	luhessinindx=ivector(1,WEIGHTNUMBER);
	readinlumatrix(luhessin,luhessinindx,WEIGHTNUMBER,LUHESSININ);
	scratchv=dvector(1,WEIGHTNUMBER);
	SCRATCHV=scratchv;
      }
      fp1=fopen(OUTPUTFILE,"w");
      if( !fp1 )   fprintf( stderr, "No such file: %s\n", OUTPUTFILE ), exit(0);
    }
  if(GEN_WRITE2){
    printf("outputs/targets will be written to %s\n",IOFILE);
    fp2=fopen(IOFILE,"w");
    if( !fp2 )   fprintf( stderr, "No such file: %s\n", IOFILE ), exit(0);
  }
  if(GEN_WRITE_RES ){
      printf("residuals will be written to %s\n",RESFILE);
    fp3=fopen(RESFILE,"w");
    if( !fp3 )   fprintf( stderr, "No such file: %s\n", RESFILE ), exit(0);
  }
  if(GEN_SENS){
      printf("sensitivities will be written to %s\n",OTHERFILE);
    fp4=fopen(OTHERFILE,"w");
    if( !fp4 )   fprintf( stderr, "No such file: %s\n", OTHERFILE ), exit(0);
  }

  if(GEN_ADD_N) randomise(wseed);
  for(k=FIRST_TRAIN;k<=NUMBER_DATA;k++){
    load_activities(k);
    forward_pass(PARAM);
    if(VERBOSE==2){
      display_xs(INPUTLAYER,0);
      display_xs(OUTPUTLAYER,1);
    }
    if(GEN_ADD_N)
      add_noise_to_outputs(PARAM);
    if(GEN_WRITE1){
      if(GEN_I_TOO)
	write_activities_to(fp1,INPUTLAYER,0); 
      write_activities_to(fp1,OUTPUTLAYER,0);
      if(GEN_BARS){
	lu_find_error_bars(PARAM,DPARAM,luhessin,luhessinindx);
	if(GEN_BARS==2)incorporate_sigma_into_error_bars(PARAM);
	write_dvector_to(fp1,ERRORBARS,1,OUTPUTN,0);
	add_error_bars_to_outputs(PARAM,-1.0);
	write_activities_to(fp1,OUTPUTLAYER,0);
	add_error_bars_to_outputs(PARAM,2.0);
	write_activities_to(fp1,OUTPUTLAYER,0);
	add_error_bars_to_outputs(PARAM,-1.0);
      }
      fprintf(fp1,"\n");
    }
    if(GEN_WRITE2){ 
      if(GEN_I_TOO)
	write_activities_to(fp2,INPUTLAYER,0); 
      write_dvector_to(fp2,targets[k],1,NUMBERIN_(OUTPUTLAYER),0);
      write_activities_to(fp2,OUTPUTLAYER,0);
      if(GEN_BARS){
	write_dvector_to(fp2,ERRORBARS,1,OUTPUTN,0);
	add_error_bars_to_outputs(PARAM,-1.0);
	write_activities_to(fp2,OUTPUTLAYER,0);
	add_error_bars_to_outputs(PARAM,2.0);
	write_activities_to(fp2,OUTPUTLAYER,0);
	add_error_bars_to_outputs(PARAM,-1.0);
      }
      fprintf(fp2,"\n");
    }
    if(GEN_WRITE_RES){
      error_signal(k);
      if(GEN_I_TOO)
	write_activities_to(fp3,INPUTLAYER,0); 
      write_residuals_to(fp3,OUTPUTLAYER,1);
    }
    if(GEN_SENS){ 
      if(GEN_I_TOO)			
	write_activities_to(fp4,INPUTLAYER,0);
      find_and_write_input_sensitivities(fp4,PARAM,1);
    }
  }
  if(GEN_WRITE1)   fclose( fp1 );
  if(GEN_WRITE2)   fclose( fp2 );
  if(GEN_WRITE_RES)fclose( fp3 );
  if(GEN_SENS)     fclose( fp4 );
}


