/*					*/
/* My routines as of December 5th 1988  */
/* With system rand */

#include	<stdio.h>
#include	<math.h>

FILE    *fopen(), *fp; 

/*************************************************
**************        Index       ****************
**************************************************/

/* list of functions that should be accepted from maths library */

double	drand48();
void 	srand48();
int 	abs();

/* my own functions */

double random_1();
int random_bit();
int random_ud_bit();
void randomise();
void pause_for_return();
int yes_or_no();
void constructfmatrix ();
void constructdmatrix ();
void printoutimatrix ();
void printoutfmatrix ();
void printoutdmatrix ();
void readindmatrix ();
void debug();
void newline(); 
#define fnewline fprintf(fp,"\n")
void readinfvector();
void printoutfvector();
void printoutivector();
void readinivector();
void readindvector();
void printoutdvector();
void print2Ddvector();
float fdot();
double ddot();
void inputf();
void inputd();
void inputi();

/* file handling routines */

void read_qspec();
void generate_q();

/*silly functions*/

double qfunction1();
double qfunction2();
double qfunction3();
void add_ca_and_printoutdmatrix();

/********************************/
/* THE FUNCTIONS */
/* my own functions */
/********************************/

double random_1()
{
	return(drand48());
}

random_bit(b)
	float b;
{
	if (random_1() >b )
		return(0);
	else
		return(1);
}

random_ud_bit(b)
	float b;
{
	if (random_1() >b )
		return(-1);
	else
		return(1);
}

void randomise(seed)
	long 	seed; /* randomisation variable */
{
	srand48(seed);
}

void pause_for_return()
{
	int c;

	printf( "press return to continue" );
	c=getchar();
}

int yes_or_no()
{
	char 	c[10];
	
	scanf("%s",c);
	if (c[0]=='y')
		return(1);
	else if (c[0]=='n')
		return(0);
	else
		return(0);
}

void constructfmatrix (M,NP,ca)
	int NP;
	float **M;
	float ca; 
{
	int i,j;
		
	for (i=0;i<=NP-1;i++){
        	for (j=0;j<=NP-1;j++){
        		M[i][j]= (float) NP - fabs((float)(i-j))+ca;
        	}
        } 
}
void constructdmatrix (M,NP,ca)
	int NP;
	double **M;
	double ca; 
{
	int i,j;
		
	for (i=0;i<=NP-1;i++){
        	for (j=0;j<=NP-1;j++){
        		M[i][j]= NP + ca - fabs((double)(i-j));
        	}
        } 
}

void printoutimatrix (M,NP)
	int NP;
	int **M;
{
	int i,j;
	
	for (i=0;i<=NP-1;i++){
        	for (j=0;j<=NP-1;j++) printf("%d ",M[i][j]);
          	printf("\n");
     	}                   
}

void printoutfmatrix (M,NP)
	int NP;
	float **M;
{
	int i,j;
	
	for (i=0;i<=NP-1;i++){
        	for (j=0;j<=NP-1;j++) printf("%7.2f",M[i][j]);
          	printf("\n");
     	}                   
}
void printoutdmatrix (M,NP)
	int NP;
	double **M;
{
	int i,j;
	
	for (i=0;i<=NP-1;i++){
        	for (j=0;j<=NP-1;j++) printf("%7.2f",M[i][j]);
          	printf("\n");
     	}                   
}
void readindmatrix (b,n,file)
	char	file[50];
	double **b;
	int n;
{
	int		l, i, j;

	fp = fopen( file, "r" );

	printf( "reading in matrix\n" );
	for (i=0; i<=n-1; i++){
		for (j=0; j<=n-1; j++){
			fscanf(fp,"%lf ",&b[i][j]);
		} 
	}	
	fclose( fp );
	printf( "matrix in\n" );
}


void debug(n)
	int n;
{
	printf("debug %d\n",n);
}

void newline()
{
	printf("\n");
}
 
void readinfvector(w,n)
	int n;
	float *w;
{
	int i;
	
	printf("Please enter %d components \n",n);
	for (i=0;i<=n-1;i++)
		scanf("%f",&w[i]);
}

void printoutfvector(w,n)
	int n;
	float *w;
{
	int i;
	
	for (i=0;i<=n-1;i++)
		printf("%f ",w[i]);
	newline();
}
void readinivector(w,n)
	int n;
	int *w;
{
	int i;
	
	printf("Please enter %d components \n",n);
	for (i=0;i<=n-1;i++)
		scanf("%d",&w[i]);
}

void printoutivector(w,n)
	int n;
	int *w;
{
	int i;
	
	for (i=0;i<=n-1;i++)
		printf("%d ",w[i]);
	newline();
}
void readindvector(w,n)
	int n;
	double *w;
{
	int i;
	
	printf("Please enter %d components \n",n);
	for (i=0;i<=n-1;i++)
		scanf("%lf",&w[i]);
}

void printoutdvector(w,n)
	int n;
	double *w;
{
	int i;
	
	for (i=0;i<=n-1;i++)
		printf("%4.2f ",w[i]);
	newline();
}

void print2Ddvector(w,n,m)
	int n,m;
	double *w;
{
	int i,j;
	
	for (i=0;i<=n-1;i+=m){
		for (j=i;j<=i+m-1;j++)
			printf("%6.2f",w[j]);
		newline();
	}
}

float fdot(a,b,n)
	float *a,*b;
	int n;
{
	int j;
	float sum=0.0;
	for (j=0;j<=n-1;j++)
		sum += a[j] * b[j];
	return (sum);
}

double ddot(a,b,n)
	double *a,*b;
	int n;
{
	int j;
	double sum=0.0;
	for (j=0;j<=n-1;j++)
		sum += a[j] * b[j];
	return (sum);
}

void inputf(pointer)
	float *pointer;
{
	scanf("%f",pointer);
}
void inputd(pointer)
	double *pointer;
{
	scanf("%lf",pointer);
}
void inputi(pointer)
	int *pointer;
{
	scanf("%d",pointer);
}

/* file handling routines */

void read_qspec(qspec,n,m)
	int *n,*m;
	char	qspec[50];
{

	fp = fopen( qspec, "r" );
	
	fscanf( fp, "%d", n );
	fscanf( fp, "%d", m );
	printf( "Have Read in qspec\n" );
	
	fclose( fp );
}

void generate_q(outputq,q,n,m)
	char	outputq[50];
	double **q;
	int n,m;
{
	int		l, i, j, k;
	
	fp = fopen( outputq, "w" );

	printf( "Generating Q\n" );
	for (i=0; i<=m-1; i++)
		for (fnewline,j=0; j<=m-1; j++)
			for (fnewline,k=0; k<=m-1; k++)
				for (fnewline,l=0; l<=m-1; l++)
					fprintf(fp,"%.10f ",q[m * i + j][m * k + l]=qfunction2(abs(i-k),abs(j-l),m)); 
	fnewline;
	fclose( fp );
	printf( "q done\n" );
}

/*silly functions*/

double qfunction1(i,j,m)
	int	i,j,m;
{
	return ((m-i)*(m-j));
}

double qfunction2(i,j,m)
	int	i,j,m;
{
	return (exp(-((double)(i * i)+(double)(j * j))/((double)m * m / 2)));
}
double qfunction3(i,j,m)
	int	i,j,m;
{
	return ((double) m- sqrt((double)(i * i)+(double)(j * j) ) );
}
	
void add_ca_and_printoutdmatrix (M,NP,ca)
	int NP;
	double ca;
	double **M;
{
	int i,j;
	
	for (i=0;i<=NP-1;i++){
        	for (j=0;j<=NP-1;j++) printf("%7.2f",M[i][j]+=ca);
          	printf("\n");
     	}                   
}

	
void add_ca_todmatrix (M,NP,ca)
	int NP;
	double ca;
	double **M;
{
	int i,j;
	
	for (i=0;i<=NP-1;i++){
        	for (j=0;j<=NP-1;j++) 
			M[i][j]+=ca;
     	}                   
}



