/* Treatout to use with newer MINMAX format ! */
/* Thomas Sourmail, Cambridge University, 2001 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

int main(int argc, char *argv[])
{
  FILE *ifp,*ofp;
  int no_of_lines,no_of_input,no_of_models,i=0;
  float min,max,pred,predm,predp,error,dummy,mean,stdev;
  char data_file[50],minmax_file[50],c;

  if(argc == 3) {
    printf("\n\n%s ","You have not precised the name of the minmax and data files\n");
    printf("%s\n","Using MINMAX and com.dat by default");
    strcpy(minmax_file,"MINMAX");
    strcpy(data_file,"com.dat");
    }
  if(argc == 5) {
    strcpy(minmax_file,argv[3]);
    strcpy(data_file,argv[4]);
  }
  if(argc != 3 && argc != 5){
    printf("\n\n%s %s %s\n\n","Usage:",argv[0],"no_of_lines no_of_input_variables Min_Max_file Data_file");
    printf("%s %s %s\n\n","or",argv[0],"no_of_lines no_of_input_variables");
    exit(0);
  }

  no_of_lines=atoi(argv[1]);
  no_of_input=atoi(argv[2]);
  printf("%d %d %s\n",no_of_lines,no_of_input,minmax_file);

  if((ifp=fopen(minmax_file,"r")) == NULL) {
    printf("Error in %s: unable to find file %s\n",argv[0],minmax_file);
    exit(0);
  }
  else {
    while((c=getc(ifp)) != '\n');
    while (++i<=(no_of_input+1))
      fscanf(ifp,"%f%f%f%f%f%f",&min,&max,&dummy,&dummy,&dummy,&dummy);
	printf("%f%f\n",min,max);
    fclose(ifp);
  }
  
  if((ifp=fopen(data_file,"r")) == NULL || (ofp=fopen("result","w")) == NULL) {
    printf("Error in %s: unable to find file %s\n",argv[0],data_file);
    printf("or to create result file\n");
    exit(0);
  }
  else {
    i=0;
    fprintf(ofp,"%s %s %s %s\n","Prediction","Error","Pred-Err","Pred+Err");
    while(++i<=no_of_lines){
      fscanf(ifp,"%f%f%f%f",&pred,&error,&predm,&predp);
      pred=(pred+0.5)*(max-min)+min;
      predm=(predm+0.5)*(max-min)+min;
      predp=(predp+0.5)*(max-min)+min;
      error=error*(max-min);
      fprintf(ofp,"%f %f %f %f\n",pred,error,predm,predp);
    }
    fclose(ifp);
    fclose(ofp);
  }
}




