c	==================================================================	
	PROGRAM MAIN

	DOUBLE PRECISION Hl(500),z(500),Hs,dz,dt,D0,Q,l,D,avel,Nl
	DOUBLE PRECISION Ht1(500),Ht2(500),Ht3(500),ave1,ave2,ave3
	DOUBLE PRECISION Eb1,Eb2,Eb3,Nt1,Nt2,Nt3
	DOUBLE PRECISION area_f(500),k1,k2,k3
	DOUBLE PRECISION ch_time,ag_time,des_time,T,Tend,dTdt,time,time1
	DOUBLE PRECISION:: R=8.314d+00,Mu=1d13,Na=6.02d23
        DOUBLE PRECISION:: mass=55.85d+00,Vm=7.09d-6
	INTEGER i,icharge,iage,ishape,mode,iter,grid

	NAMELIST /specimen/ D0,Q,l,Hs,Eb1,Eb2,Eb3,Nl,Nt1,Nt2,Nt3
	NAMELIST /analysis/ mode,ch_time,ag_time,des_time,dt,T,Tend,dTdt
	NAMELIST /option/ icharge,iage,ishape,grid


	OPEN (unit=1,file='in.txt',status='old')
		READ(1,specimen)
		READ(1,analysis)
		READ(1,option)
        write(*,*)icharge, iage, ishape,grid
	CLOSE (1)
	
	time=0.0
	time1=0.0
	DO i=1,GRID
		Hl(i) = 0.0D+00
	ENDDO

	dz=l/GRID
	z(1)=dz/2
	DO i=2,GRID
		z(i) = z(i-1)+dz
	ENDDO

	D = D0*dexp(-Q/R/T)
	DO WHILE (dt.ge.(dz*dz/3/D)) 
		dt = dt*0.5D+00
		WRITE (*,*) 'too large dt_FDM'
	ENDDO

	IF(ishape==1) THEN

		area_f(1)=dz*dz/l/l
		DO i=2,GRID
			area_f(i)=dz*dz*(i*i-(i-1)*(i-1))/l/l
		ENDDO
	ENDIF


	OPEN (unit=10,file='lattice.txt',status='unknown')

	Nl=Nl*Vm/mass/Na*1e6

	IF (Nt1.gt.0) THEN
		k1=dexp(Eb1/R/T)
		Nt1=Nt1*Vm/mass/Na*1d6
		OPEN (unit=11,file='trap1.txt',status='unknown')
	END IF

	IF (Nt2.gt.0) THEN
		k2=dexp(Eb2/R/T)
		Nt2=Nt2*Vm/mass/Na*1d6
		OPEN (unit=12,file='trap2.txt',status='unknown')
	END IF

	IF (Nt3.gt.0) THEN
		k3=dexp(Eb3/R/T)
		Nt3=Nt3*Vm/mass/Na*1d6
		OPEN (unit=13,file='trap3.txt',status='unknown')
	END IF
			
	DO WHILE (time.lt.ch_time) 

		IF(icharge==0) THEN			
			OPEN (unit=2,file='charging.txt',status='old')
				READ(2,*) z
				READ(2,*) Hl
				READ(2,*) Ht1
				READ(2,*) Ht2
				READ(2,*) Ht3
			CLOSE(2)
			goto 10
		ENDIF

		IF(ishape==0) THEN
			CALL FDM(Hl,Hs,D,dz,dt,grid)
		ELSE 
			CALL FDM_s(Hl,Hs,D,dz,dt,z,grid)
		ENDIF

		IF(time1.ge.des_time) THEN
			WRITE (10,'(F9.0,F7.2, 5000E11.4)') time,T-273,Hl
			WRITE (11,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht1
			WRITE (12,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht2
			WRITE (13,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht3
			time1=0
		ENDIF

		DO i=1,GRID

			IF(Nt1.gt.0) THEN
				CALL local_eq(Hl(i),Ht1(i),Nl,Nt1,k1,T)

			ENDIF

			IF(Nt2.gt.0) THEN
				CALL local_eq(Hl(i),Ht2(i),Nl,Nt2,k2,T)
			ENDIF
				
			IF(Nt3.gt.0) THEN
				CALL local_eq(Hl(i),Ht3(i),Nl,Nt3,k3,T)
			ENDIF

		ENDDO
			
		time=time+dt
		time1=time1+dt

	ENDDO

	IF(ishape==0) THEN
		avel=sum(Hl)/GRID
		ave1=sum(Ht1)/GRID
		ave2=sum(Ht2)/GRID
		ave3=sum(Ht3)/GRID
	ELSE
		avel=sum(Hl*area_f)
		ave1=sum(Ht1*area_f)
		ave2=sum(Ht2*area_f)
		ave3=sum(Ht3*area_f)
	ENDIF
	
	WRITE (10,'(F9.0,F7.2, 5000E11.4)') time,T-273,Hl
	WRITE (10,*) '------------------------------------'
	WRITE (11,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht1
	WRITE (11,*) '------------------------------------'
	WRITE (12,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht2
	WRITE (12,*) '------------------------------------'
	WRITE (13,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht3
	WRITE (13,*) '------------------------------------'

	OPEN(unit=2,file='charging.txt',status='unknown')
		WRITE (2,'(500E11.4)') z
		WRITE (2,'(500E11.4)') Hl
		WRITE (2,'(500E11.4)') Ht1
		WRITE (2,'(500E11.4)') Ht2
		WRITE (2,'(500E11.4)') Ht3
		WRITE (2,'(F9.0,4E11.4)') time,avel,ave1,ave2,ave3
	CLOSE(2)


10	time=0.0
	time1=0.0
	Hs=0.0

	DO WHILE (time.lt.ag_time) 

		IF(iage==0) THEN			
			OPEN (unit=3,file='aging.txt',status='old')
				READ(3,*) z
				READ(3,*) Hl
				READ(3,*) Ht1
				READ(3,*) Ht2
				READ(3,*) Ht3
			CLOSE(3)
			goto 11
		ENDIF

		IF(ishape==0) THEN
			CALL FDM(Hl,Hs,D,dz,dt,grid)
		ELSE 
			CALL FDM_s(Hl,Hs,D,dz,dt,z,grid)
		ENDIF

		IF(time1.ge.des_time) THEN
			WRITE (10,'(F9.0,F7.2, 5000E11.4)') time,T-273,Hl
			WRITE (11,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht1
			WRITE (12,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht2
			WRITE (13,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht3
			time1=0
		ENDIF

		DO i=1,GRID

			IF(Nt3.gt.0) THEN
				CALL local_eq(Hl(i),Ht3(i),Nl,Nt3,k3,T)
			ENDIF

			IF(Nt2.gt.0) THEN
				CALL local_eq(Hl(i),Ht2(i),Nl,Nt2,k2,T)
			ENDIF
				
			IF(Nt1.gt.0) THEN
				CALL local_eq(Hl(i),Ht1(i),Nl,Nt1,k1,T)
			ENDIF

		ENDDO

	
		time=time+dt
		time1=time1+dt

	ENDDO

	IF(ishape==0) THEN
		avel=sum(Hl)/GRID
		ave1=sum(Ht1)/GRID
		ave2=sum(Ht2)/GRID
		ave3=sum(Ht3)/GRID
	ELSE
		avel=sum(Hl*area_f)
		ave1=sum(Ht1*area_f)
		ave2=sum(Ht2*area_f)
		ave3=sum(Ht3*area_f)
	ENDIF

	WRITE (10,'(F9.0,F7.2, 5000E11.4)') time,T-273,Hl
	WRITE (10,*) '------------------------------------'
	WRITE (11,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht1
	WRITE (11,*) '------------------------------------'
	WRITE (12,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht2
	WRITE (12,*) '------------------------------------'
	WRITE (13,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht3
	WRITE (13,*) '------------------------------------'

	OPEN(unit=3,file='aging.txt',status='unknown')
		WRITE (3,'(500E11.4)') z
		WRITE (3,'(500E11.4)') Hl
		WRITE (3,'(500E11.4)') Ht1
		WRITE (3,'(500E11.4)') Ht2
		WRITE (3,'(500E11.4)') Ht3
		WRITE (3,'(F9.0,4E11.4)') time,avel,ave1,ave2,ave3
	CLOSE(3)

11	time=0
	time1=0
	WRITE (*,*) '***start desorption***'
	iter=0

	OPEN (unit=20,file='RESULTS.txt',status='unknown')
	WRITE(20,'(F9.2,E11.4)') T-273,avel+ave1+ave2+ave3

	DO WHILE (T.le.Tend) 

		IF(ishape==0) THEN
			CALL FDM(Hl,Hs,D,dz,dt,grid)
		ELSE 
			CALL FDM_s(Hl,Hs,D,dz,dt,z,grid)
		ENDIF

		IF(time1.ge.des_time) THEN
			WRITE (10,'(F9.0,F7.2, 5000E11.4)') time,T-273,Hl
			WRITE (11,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht1
			WRITE (12,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht2
			WRITE (13,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht3
			IF(ishape==0) THEN
				avel=sum(Hl)/GRID
				ave1=sum(Ht1)/GRID
				ave2=sum(Ht2)/GRID
				ave3=sum(Ht3)/GRID
			ELSE
				avel=sum(Hl*area_f)
				ave1=sum(Ht1*area_f)
				ave2=sum(Ht2*area_f)
				ave3=sum(Ht3*area_f)
			ENDIF

			WRITE(20,'(F9.2,E11.4)') T-273,avel+ave1+ave2+ave3
			time1=0

		ENDIF

		DO i=1,GRID

			IF(mode.eq.0) THEN

				IF(Nt3.gt.0) THEN
					CALL kinetic(Hl(i),Ht1(i),Nl,Nt3,Q,Eb3,dt,T)
				ENDIF

				IF(Nt2.gt.0) THEN
					CALL kinetic(Hl(i),Ht2(i),Nl,Nt2,Q,Eb2,dt,T)
				ENDIF
						
				IF(Nt1.gt.0) THEN
					CALL kinetic(Hl(i),Ht1(i),Nl,Nt1,Q,Eb1,dt,T)
				ENDIF

			ELSE

				IF(Nt3.gt.0) THEN
					CALL local_eq(Hl(i),Ht3(i),Nl,Nt3,k3,T)
				ENDIF

				IF(Nt2.gt.0) THEN
					CALL local_eq(Hl(i),Ht2(i),Nl,Nt2,k2,T)
				ENDIF
						
				IF(Nt1.gt.0) THEN
					CALL local_eq(Hl(i),Ht1(i),Nl,Nt1,k1,T)
				ENDIF

			ENDIF

		ENDDO

		DO WHILE (dt.ge.(dz*dz/3/D)) 
			dt = dt*0.5D+00
			WRITE (*,*) 'too large dt_FDM'
		ENDDO
	
		T=T+dTdt*dt
		time=time+dt
		time1=time1+dt
		iter=iter+1

		IF (mod(iter,400000).eq.0) THEN
			WRITE (*,'(F11.2)') T-273
		ENDIF

		D = D0*dexp(-Q/R/T)

		IF(Nt1.gt.0) THEN
			k1=dexp(Eb1/R/T)
		ENDIF

		IF(Nt2.gt.0) THEN
			k2=dexp(Eb2/R/T)
		ENDIF
				
		IF(Nt3.gt.0) THEN
			k3=dexp(Eb3/R/T)
		ENDIF

	ENDDO

	IF(ishape==0) THEN
		avel=sum(Hl)/GRID
		ave1=sum(Ht1)/GRID
		ave2=sum(Ht2)/GRID
		ave3=sum(Ht3)/GRID
	ELSE
		avel=sum(Hl*area_f)
		ave1=sum(Ht1*area_f)
		ave2=sum(Ht2*area_f)
		ave3=sum(Ht3*area_f)
	ENDIF

	WRITE (10,'(F9.0,F7.2, 5000E11.4)') time,T-273,Hl
	WRITE (10,*) '------------------------------------'
	WRITE (11,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht1
	WRITE (11,*) '------------------------------------'
	WRITE (12,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht2
	WRITE (12,*) '------------------------------------'
	WRITE (13,'(F9.0,F7.2, 5000E11.4)') time,T-273,Ht3
	WRITE (13,*) '------------------------------------'


	OPEN(unit=4,file='desorption.txt',status='unknown')
		WRITE (4,'(500E11.4)') z
		WRITE (4,'(500E11.4)') Hl
		WRITE (4,'(500E11.4)') Ht1
		WRITE (4,'(500E11.4)') Ht2
		WRITE (4,'(500E11.4)') Ht3
		WRITE (4,'(F9.0,4E11.4)') time,avel,ave1,ave2,ave3
	CLOSE(4)

	END
c	===================================================================
	SUBROUTINE FDM(Hl,Hs,D,dz,dt,grid)

	DOUBLE PRECISION Hl(500),Hl_update(500),Hs,D,dz,dt
	INTEGER i,grid

	DO i=1,grid
		IF (i.eq.1) THEN
			Hl_update(i)=Hl(i)+D*dt/dz/dz*( Hl(i)-2*Hl(i)+Hl(i+1) )
		ELSE IF (i.eq.grid) THEN
			Hl_update(i)=Hs
c			Hl_update(i)=Hl(i)+D*dt/dz/dz*( Hl(i)-2*Hl(i)+Hs )
		ELSE
			Hl_update(i)=Hl(i)+D*dt/dz/dz*( Hl(i-1)-2*Hl(i)+Hl(i+1) )
		ENDIF
	ENDDO

	DO i=1,grid
		Hl(i)=Hl_update(i)
	ENDDO

	END SUBROUTINE
c	===================================================================
	SUBROUTINE FDM_s(Hl,Hs,D,dz,dt,z,grid)

	DOUBLE PRECISION Hl(500),Hl_update(500),Hs,D,dz,dt,z(500)
	INTEGER i,grid

	DO i=1,grid
		IF (i.eq.1) THEN
			Hl_update(i)=Hl(i)+D*dt/dz/dz*( Hl(i)-2*Hl(i)+Hl(i+1) )+
     &D*dt/dz/z(i)*( Hl(i+1)-Hl(i) )
		ELSE IF (i.eq.grid) THEN
			Hl_update(i)=Hs
c			Hl_update(i)=Hl(i)+D*dt/dz/dz*( Hl(i)-2*Hl(i)+Hs )+
c     &D*dt/dz/z(i)*( Hs-Hl(i) )
		ELSE
			Hl_update(i)=Hl(i)+D*dt/dz/dz*( Hl(i-1)-2*Hl(i)+Hl(i+1) )+
     &D*dt/dz/z(i)*( Hl(i+1)-Hl(i) )
		ENDIF
	ENDDO

	DO i=1,grid
		Hl(i)=Hl_update(i)
	ENDDO

	END SUBROUTINE
c	================================================================
	SUBROUTINE local_eq(Hl,Ht,Nl,Nt,k,T)

	DOUBLE PRECISION Hl,Ht,Nl,Nt,Eb,k,T
	DOUBLE PRECISION y1,y2,y3,gl,gt,total

		total=Hl+Ht
		IF (total.le.1d-20) THEN
			GOTO 600
		ENDIF

		gl=Hl/Nl
		gt=Ht/Nt

		y1=Nt
		y2=-1*(total+Nl/k+Nt)
		y3=total

		gt=(-y2-dsqrt(y2**2-4*y1*y3))/2/y1

		Ht=gt*Nt
		Hl=total-Ht
		
		IF ((total-Ht).le.1d-20) THEN
			Hl=0.0
		ENDIF


600	END SUBROUTINE
c	================================================================
	SUBROUTINE kinetic(Hl,Ht,Nl,Nt,Q,Eb,dt,T)

	DOUBLE PRECISION Hl,Nl,Ht,Nt,Q,Eb,dt,T
	DOUBLE PRECISION Ht_up,Hl_up,Plt,Ptl,prob


100		Plt=prob(Nt,Nl,Ht,Hl,Q,T,dt)
		Ptl=prob(Nl,Nt,Hl,Ht,Eb+Q,T,dt)

		Hl_up=Ht*Ptl+Hl*(1D+00-Plt)
		Ht_up=Hl*Plt+Ht*(1D+00-Ptl)

		IF ( Ht_up<0 .or. Ht_up>Nt) THEN

			dt=dt*0.5D+00
			WRITE (*,*) 'too large dt'
			WRITE(4,'(F9.2,E11.4,a)') T-273,dt,'  2'

			GOTO 100
		ENDIF

		Hl=Hl_up
		Ht=Ht_up

	END SUBROUTINE

c	+++++++++++++++++++++++++++++++++++++++++++
	DOUBLE PRECISION FUNCTION prob(Nt,Nl,Ht,Hl,Q,T,dt)

	DOUBLE PRECISION Nt,Nl,Ht,Hl,Q,k,T,dt,R,MU

		R=8.314D+00
		MU=1d13

		k=dexp(-Q/R/T)

		prob=k*(Nt-Ht)/(Nt+Nl-(Ht+Hl))
		prob=1.0D+00-(1.0D+00-prob)**(MU*dt)

		RETURN
	END