C                     Aum Sri Sairam
C     
C     -*--*--*--*--*--*--*--*--*--*--*--*--*--*--*--*--*--*--*--*--*-
C     
C     
C     Copyright M.Murugananth
C     Phase Transformation and Complex Properties Group
C     Department of Material Science and Metallurgy 
C     University Of Cambridge
C     
C     -*--*--*--*--*--*--*--*--*--*--*--*--*--*--*--*--*--*--*--*--*-
C     
C     TO CALL THE MTDATA AS SLAVE
C
C    ~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~
C    CALCULATES AE3 and AE1 for a Given composition using MTDATA
C
C    ~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~~*~
C
C
C
C     
C***************************************************************
C     
C     ------------------------------------------------------------
C     Variables and functions used in this program that are called 
C     from the MTDATA application
C     ------------------------------------------------------------
C     
C     
C     
C     OPEN_MPI_FILE(FILE1, FILE2,IERR)
C     SET_PRINT_LEVEL(WEIGHT_TABLE)
C     SET_TEMPERATURE(873.0D0)
C     SET_PRESSURE(101325.0D0)
C     SET_SYSTEM_WEIGHT(1.0D0)
C     INIT_NO_OF_COMPONENTS()
C     INIT_COMPONENT_NAME(I)
C     SET_INIT_COMPONENT_MASS(I,AMOUNT1)
C     SET_INIT_PHASE_CLASS(I2,NORMAL)
C     NUMBER_OF_ERRORS()
C     INIT_COMPONENT_MOLES(I)
C     INIT_COMPONENT_MASS(I)
C     SUM_OF_COMPONENT_AMOUNT()
C     SUM_OF_COMPONENT_MASS()
C     TEMPERATURE()
C     PRESSURE()
C     SYSTEM_GIBBS_ENERGY()
C     SYSTEM_ENTHALPY()
C     SYSTEM_ENTROPY()
C     SYSTEM_VOLUME()
C     PARTIAL_SYSTEM_GIBBS_ENERGY(I)
C     EQUIL_NO_OF_PHASES()
C     ACT_NO_OF_PHASES()
C     MOLES_OF_COMPONENTS_IN_PHASE(I,ACTIVE)
C     MASS_IN_PHASE(I,ACTIVE)
C     ACT_PHASE_NAME(I)
C     ACT_NO_OF_COMPONENTS()
C     COMPONENT_W_OF_PHASE(J,I,ACTIVE)
C     ACT_COMPONENT_NAME(J)
C     COMPONENT_X_OF_PHASE(J,I,ACTIVE)
C     COMPONENT_MOLES_IN_PHASE(J,I,ACTIVE)
C
C
C****************************************************************
C
C     ---------------------------------------------------
C
C     NON -MTDATA VARIABLE INCLUDED USED BY Murugananth.M
C     
C     ---------------------------------------------------
C
C
C     AR_I  defines the each composition variable
C     AR_J defines the number of lines
C     NO__OF_LINES gives the limit to the number of lines
C
C
C
C   
C****************************************************************


      PROGRAM AE

      
      INCLUDE'/home4/users/guest/mt472obj/DIRUSRAP.FOR'
      CHARACTER*80 FILE1, FILE2,NAME
      CHARACTER TEMP_FILE*14,EXTN_NUM*3
C     IMPLICIT DOUBLE PRECISION(A-H,0-Z), INTEGER(I-N)
      DOUBLE PRECISION AMOUNT1(10000, 100), AMNT, NO_OF_PHASES
      DOUBLE PRECISION LOG_T(10000)
      DOUBLE PRECISION TOTAL_MOLES, MOLE_FRAC(500)
      DOUBLE PRECISION  TEMP_D(10000), SOLID_SOLN(100),HCP(100)
      INTEGER AR_I,AR_J, INC, AR_JJ, TEMP_I, NO_OF_LINES, SLNI
      DOUBLE PRECISION TEMP, AE3(10000), AE1(10000), COUNTER,COUNTERR
      DOUBLE PRECISION COUNTER2, COUNTERR2, TMIN, TMAX, TSTEP,CHECK_COMP
      DOUBLE PRECISION SKIP
      DOUBLE PRECISION CHECK_LOOP
      OPEN (UNIT=1,FILE='AE_MTDATA_OUTPUT')
      OPEN(UNIT=2,FILE='comp_data')
      OPEN(UNIT=7,FILE='skip_data_line')
      OPEN(UNIT=996,FILE='equil_temp')
C      OPEN(UNIT=4,FILE='temp_only')
C      OPEN(UNIT=999,FILE='log_time_only')

C     OPEN(UNIT=995,FILE='SOLID_SOLN')
      IMODE=0
      WRITE(*,*)'INITIALISING MTDATA...'
      
      CALL INITIALISE_MTDATA(IMODE)
      CALL SGUMEN(1)
      CALL SGUMEN(7)

      WRITE(*,*)
      WRITE(SCREEN(),*) 'GAS CONSTANT = ', GAS_CONSTANT()
      WRITE(1,*) 'GAS CONSTANT = ', GAS_CONSTANT()
      WRITE(*,*)

      
C     CALL MTOPTN(2,'SYSTEM_RESIZE=100')
      CALL MTOPTN(2,'STAGE_1=NEW')
      
      WRITE(*,*)'ENTER mpi FILENAME (with extn.):'
      READ (5,*) FILE1
      WRITE(*,*)'ENTER mpr FILENAME (with extn.):'
      READ (5,*) FILE2
      
      IERR=0
      

      WRITE(*,*) 'TYPE THE NUMBER OF LINES IN THE DATABASE'
      READ(*,*) NO_OF_LINES
      WRITE (*,*) 'NUMBER OF LINES IN THE DATABASE',
     & NO_OF_LINES

      CALL OPEN_MPI_FILE( FILE1, FILE2,IERR)
      CALL SET_PRINT_LEVEL(WEIGHT_TABLE)
      IF (IERR .NE. 0) THEN
         WRITE(*,*) 'FAILURE IN MPI FILE READ, ERROR=',IERR
      ELSE
         WRITE (*,*)
         WRITE (*,*)
         WRITE (*,*)
         WRITE (*,*)
         CALL SET_PRESSURE(101325.0D0)
         CALL SET_SYSTEM_WEIGHT(100.0D0)

         WRITE (*,*) '---------------------------'
         WRITE (*,*) 'NO OF COMPONENTS =', INIT_NO_OF_COMPONENTS()
         WRITE (*,*) '---------------------------'

         INC=INIT_NO_OF_COMPONENTS()-1
         READ (2,*) ((AMOUNT1(AR_J,AR_I), AR_I=1, INC), 
     &        AR_J=1,NO_OF_LINES)



C         DO 8989 TEMP_I=1, NO_OF_LINES
C            READ(4,*) TEMP_D(TEMP_I)
C            READ(999,*) LOG_T(TEMP_I)
C            WRITE(*,*) 'JUST AFTER READING', TEMP_D(TEMP_I),
C     & LOG_T(TEMP_I)
C         READ(4,*) (TEMP_D(TEMP_I),TEMP_I=1, NO_OF_LINES)
C 8989    CONTINUE





         AR_I=1
         AR_JJ=NO_OF_LINES




C@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
C@@@@@@@@@@@@@@@@@@@@                                @@@@@@@@@@@@@@@@@@
C@@@@@@@@@@@@@@@@@@@@ Calculation for Ae starts here @@@@@@@@@@@@@@@@@@
C@@@@@@@@@@@@@@@@@@@@                                @@@@@@@@@@@@@@@@@@
C@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@


            DO 999 AR_I=1, NO_OF_LINES
               COUNTER=0
               COUNTER2=0
               COUNTERR=0
               COUNTERR2=0
               CHECK_LOOP=0.0
               AMNT=0
               WRITE(1,*)'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@'
               WRITE(1,*)'         COMPOSITION', AR_I
               WRITE(1,*)'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@'     
               WRITE(*,*)
               WRITE(*,*)'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@'
               WRITE(*,*)'         COMPOSITION', AR_I
               WRITE(*,*)'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@'     
               WRITE(*,*)
               
               TEMP_FILE='EQILIBRIUM_temp'
               OPEN(UNIT=3,FILE=TEMP_FILE)
               WRITE(3,*)'----------------------------------'
               WRITE(3,*)'        COMPOSITION ', AR_I
               WRITE(3,*)'----------------------------------'
               
               
               WRITE(*,*)
               WRITE(*,*) 'APPLICATION OUTPUT - FOR ANANTH'
               WRITE(*,*) '================================'
               WRITE(*,*)
               
               
               WRITE(1,*)
               WRITE(1,*) 'APPLICATION OUTPUT - FOR ANANTH'
               WRITE(1,*) '==============================='
               WRITE(1,*)
               
               
               CHECK_COMP=0.0
               DO 2003 I=1, INIT_NO_OF_COMPONENTS()-1
                  WRITE(*,*) 'CHECK_COMP ', CHECK_COMP,AMOUNT1(AR_I,I)
     & ,AMOUNT1(AR_I-1,I) 
                  IF (AMOUNT1(AR_I,I) .EQ. AMOUNT1((AR_I-1),I)) THEN
                     CHECK_COMP=CHECK_COMP+1
                     IF(CHECK_COMP .EQ. INIT_NO_OF_COMPONENTS()-1) THEN
                        WRITE(*,*) 'COMPOSITION ',AR_I,' =  COMPOSITION 
     &', AR_I-1

                        WRITE(1,*) 'COMPOSITION ',AR_I,' =  COMPOSITION 
     & ', AR_I-1
                        GOTO 2002
                     ENDIF
                  ENDIF
               
 2003          CONTINUE

C---------Initialising the read composition -------------
               
               DO 10 I=1, INIT_NO_OF_COMPONENTS()
C     INITIALISING THE AMOUNT OF COMPONENTS
                  IF (I .NE. INIT_NO_OF_COMPONENTS()) THEN
                     WRITE(*,771) I, 
     &                    INIT_COMPONENT_NAME(I),
     &                    AMOUNT1(AR_I,I), AMOUNT1(AR_I-1,I)
                     
                     WRITE(1,771) I, 
     &                    INIT_COMPONENT_NAME(I),
     &                    AMOUNT1(AR_I,I)
                     AMNT=AMOUNT1(AR_I,I)+AMNT
C     AR_I=AR_I+1
                  ELSE
                     AMOUNT1(AR_I,I)=100-AMNT
                  WRITE(*,771) I, 
     &                    INIT_COMPONENT_NAME(I)
     &                    ,AMOUNT1(AR_I,I)
                  
                  WRITE(1,771) I, 
     &                 INIT_COMPONENT_NAME(I)
     &                 ,AMOUNT1(AR_I,I)                  
               ENDIF
               
               CALL SET_INIT_COMPONENT_MASS(I,AMOUNT1(AR_I,I))
 10         CONTINUE
            
            
C--------- Inialising composition--------------- ENDS------
            
            
            
 771        FORMAT(I5,' ', A16,' ', F10.5)
            WRITE(*,*)
            NO_OF_PHASES=11
            WRITE(*,*)
            WRITE(*,*)'NO OF PHASES IN THE SYSTEM', INIT_NO_OF_PHASES
            DO 40 I=1,INIT_NO_OF_COMPONENTS()
               WRITE(*,*) 'AMOUNT OF ', INIT_COMPONENT_NAME(I),'=',
     &              INIT_COMPONENT_MOLES(I)
               
               WRITE(1,*) 'MOLES OF ',INIT_COMPONENT_NAME(I)
     &              ,'= ', INIT_COMPONENT_MOLES(I)               
 40         CONTINUE
            
            DO 41 I=1, INIT_NO_OF_COMPONENTS()
               WRITE(*,*)'MASS OF ', INIT_COMPONENT_NAME(I),'=',
     &              INIT_COMPONENT_MASS(I)
               
               WRITE(1,*)'MASS OF ', INIT_COMPONENT_NAME(I),'=',
     &              INIT_COMPONENT_MASS(I)               
 41         CONTINUE
 
CCCC~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
CCCC~~~~~~~~~~~~~~~~~TEMPERATURE STEPPING STARTS HERE ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
CCCC~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

            TMIN=873.0
            TMAX=1273.0
            TSTEP=2.0


 2000       DO 2001 TEMP=TMIN, TMAX, TSTEP
               CALL SET_TEMPERATURE(TEMP)
C               WRITE(*,*)
C               WRITE (*,*) 'COMP', AR_I, '  TEMPERATURE', TEMP
            
            DO 991 I2=1, NO_OF_PHASES
C               WRITE(*,*) I2,'   ',ACT_PHASE_NAME(I2)
               CALL  SET_INIT_PHASE_CLASS(I2,NORMAL)
 991        CONTINUE
            
            WRITE(*,*)
            
         CALL COMPUTE_EQUILIBRIUM
         
         
         IF (NUMBER_OF_ERRORS() .NE. 0) THEN
            
            CALL WRITE_ERROR
            
         ELSE

           

            WRITE(*,*)
            WRITE(*,*)'AMOUNT OF SYSTEM = ',
     &           SUM_OF_COMPONENT_AMOUNT()
            WRITE(*,*)'MASS OF SYSTEM = ',SUM_OF_COMPONENT_MASS()
            WRITE(*,*)
            WRITE(1,*)
            WRITE(1,*)'AMOUNT OF SYSTEM = ',
     &           SUM_OF_COMPONENT_AMOUNT()
            WRITE(1,*)'MASS OF SYSTEM = ',SUM_OF_COMPONENT_MASS()
            WRITE(1,*)
 
          
            WRITE(*,*) 'TEMPERATURE  =', TEMPERATURE()
            WRITE(*,*) 'PRESSURE     =', PRESSURE()
            WRITE(*,*)
            WRITE(*,*) 'SYSTEM GIBBS ENERGY  =', SYSTEM_GIBBS_ENERGY()
            WRITE(*,*) 'SYSTEM ENTHALPY      =',SYSTEM_ENTHALPY()
            WRITE(*,*) 'SYSTEM ENTROPY       =', SYSTEM_ENTROPY()
            WRITE(*,*) 'SYSTEM VOLUME        =',SYSTEM_VOLUME()
            WRITE(*,*)
C            WRITE(*,*) 'COMOPONENT          CHEMICAL POTENTIAL'
            WRITE(1,*) 'TEMPERATURE  =', TEMPERATURE()
            WRITE(1,*) 'PRESSURE     =', PRESSURE()
            WRITE(1,*)
            WRITE(1,*) 'SYSTEM GIBBS ENERGY  =', SYSTEM_GIBBS_ENERGY()
            WRITE(1,*) 'SYSTEM ENTHALPY      =',SYSTEM_ENTHALPY()
            WRITE(1,*) 'SYSTEM ENTROPY       =', SYSTEM_ENTROPY()
            WRITE(1,*) 'SYSTEM VOLUME        =',SYSTEM_VOLUME()
            WRITE(1,*)
            WRITE(1,*) 'COMOPONENT          CHEMICAL POTENTIAL'
            
            
            DO 30 I=1,ACT_NO_OF_COMPONENTS()
C              WRITE(*,*)ACT_COMPONENT_NAME(I),
C     &              PARTIAL_SYSTEM_GIBBS_ENERGY(I)
               WRITE(1,*)ACT_COMPONENT_NAME(I),
     &              PARTIAL_SYSTEM_GIBBS_ENERGY(I)
 30         CONTINUE
            
            
            WRITE(*,*)
            WRITE(*,*) 'NUMBER OF STABLE PHASES =  ',
     &           EQUIL_NO_OF_PHASES()
            WRITE(*,*)
            
            WRITE(1,*)
            WRITE(1,*) 'NUMBER OF STABLE PHASES =  ',
     &           EQUIL_NO_OF_PHASES()
            WRITE(1,*)
            
            TOTAL_MOLES=0.0
            
            
            DO 994 I=1,ACT_NO_OF_PHASES()
               
               TOTAL_MOLES=TOTAL_MOLES+
     &              MOLES_OF_COMPONENTS_IN_PHASE(I,ACTIVE)
               
 994        CONTINUE
            
C            WRITE(*,*) TEMP_FILE

CCCC-------Condition for finding Ae temperatures-------------
            WRITE(3,*)
            WRITE(3,*)TEMP
            WRITE(3,*)           
            DO 20 I=1,ACT_NO_OF_PHASES()
C               WRITE(*,*)'MASS OF  ',ACT_PHASE_NAME(I)
C     & ,'=', MASS_IN_PHASE(I,ACTIVE),' at  ', TEMP

               WRITE(3,*)'MASS OF  ',ACT_PHASE_NAME(I)
     & ,'=', MASS_IN_PHASE(I,ACTIVE)

               IF(ACT_PHASE_NAME(I) .EQ. 'FCC_A1') THEN
                  IF(MASS_IN_PHASE(I,ACTIVE) .GT. 1 .AND. 
     &  COUNTER .EQ. 0) THEN
                     AE1(AR_I)=TEMP
                     WRITE(*,*)'MASS OF',ACT_PHASE_NAME(I)
     & ,'=', MASS_IN_PHASE(I,ACTIVE),'at', TEMP,'AE1(AR_I)', AE1(AR_I)
                     COUNTER=COUNTER+1
                  ENDIF
               ENDIF


               IF(ACT_PHASE_NAME(I) .EQ. 'BCC_A2') THEN
                  IF(MASS_IN_PHASE(I,ACTIVE) .EQ. 0 .AND. 
     &  COUNTERR .EQ. 0) THEN
                     AE3(AR_I)=TEMP
                     WRITE(*,*)'MASS OF',ACT_PHASE_NAME(I)
     & ,'=', MASS_IN_PHASE(I,ACTIVE),'at', TEMP,'AE3', AE3(AR_I)
                     COUNTERR=COUNTERR+1
                  ENDIF
               ENDIF



 20         CONTINUE
            WRITE(*,*)
            WRITE(*,*)
            WRITE(*,*)
            WRITE(*,*)COUNTER,COUNTERR,COUNTER2,COUNTERR2
            WRITE(*,*)

            IF (COUNTER .EQ. 1 .AND. COUNTER2 .EQ. 0) THEN
            WRITE(3,*)TEMP_D(AR_I),' AE1 =    ',AE1(AR_I),'   AE3 =  ',AE3(AR_I)
            WRITE(*,*)
            WRITE(*,*)
            WRITE(*,*)
            WRITE(*,*)TEMP_D(AR_I),' AE1 =    ',AE1(AR_I),'   AE3 =  ',AE3(AR_I)
            WRITE(*,*)
            WRITE(*,*)
            WRITE(*,*)
            COUNTER2=COUNTER2+1
            ENDIF


            IF (COUNTERR .EQ. 1 .AND. COUNTERR2 .EQ. 0) THEN
               WRITE(3,*)TEMP_D(AR_I), ' AE1 =    ',AE1(AR_I),'   
     & AE3 =  ',AE3(AR_I)
               WRITE(996,9966)AE1(AR_I),AE3(AR_I)
               WRITE(*,*)
               WRITE(*,*)
               WRITE(*,*)
               WRITE(*,*)TEMP_D(AR_I),' AE1 =    ',AE1(AR_I),'   AE3 =  
     & ',AE3(AR_I)
               WRITE(*,*)
               WRITE(*,*)
               WRITE(*,*)
               COUNTERR2=COUNTERR2+1
               GOTO 2002
            ENDIF

            IF(COUNTERR .EQ. 0 .AND. TEMP .EQ. TMAX) THEN
            TMIN=TEMP
            TMAX=1473.0
            WRITE(*,*) 'TMAX in LOOP ', TMAX, TEMP
            IF(TEMP .EQ. TMAX) THEN 
               CHECK_LOOP=1.0
               WRITE(*,*) 'TMAX in LOOP 1', TMAX
               WRITE(*,*)'***********************'
               WRITE(*,*)COUNTER,COUNTER2,COUNTERR,COUNTERR2,
     & CHECK_LOOP
               WRITE(*,*)'***********************'
               IF (COUNTERR .EQ. 0 .AND. COUNTERR2 .EQ. 0) THEN
                  AE3(AR_I)=9999.0
                  COUNTER=0
                  COUNTER2=0
                  COUNTERR=0
                  COUNTERR2=0
               ENDIF
               WRITE(*,*)'AE1 ',AE1(AR_I),' AE3  ', AE3(Ar_I)
               GOTO 2002 
            ENDIF
            goto 2000
            ENDIF

         ENDIF


 9966    FORMAT(F10.5,' ',F10.5)

         CHECK_LOOP=1.0
         SKIP=0.0
 2001 CONTINUE

      
 2002 IF (COUNTER .EQ. 0 .AND. COUNTERR .EQ. 0
     & .AND. COUNTER2 .EQ. 0 .AND. COUNTERR2 .EQ. 0
     & .AND. (CHECK_LOOP .EQ. 1.0 .OR. SKIP .EQ. 1)) THEN
      WRITE(3,*)' Skipping composition  data no :   ', AR_I
      WRITE(7,*) AR_I
      WRITE(*,*)' Skipping composition  data no :   ', AR_I
      SKIP=1.0
      ENDIF

      IF(CHECK_COMP .EQ. INIT_NO_OF_COMPONENTS()-1) THEN
         WRITE(1,*) 'COMPOSITION ',AR_I,' =  COMPOSITION 
     & ', AR_I-1, '      -------------CHECK 2----------'
         WRITE(*,*)
         AE1(AR_I)=AE1(AR_I-1)
         AE3(AR_I)=AE3(AR_I-1)
         IF(SKIP .NE. 1.0) THEN
            WRITE(3,*)TEMP_D(AR_I), ' AE1 =    ',AE1(AR_I),
     &           '   AE3 =  ',AE3(AR_I)
            
            WRITE(996,9966) AE1(AR_I),AE3(AR_I)

         ENDIF
      ENDIF
      
      IF(CHECK_LOOP .EQ. 1) THEN
         COUNTER=0
         COUNTER2=0
         COUNTERR=0
         COUNTERR2=0
         CHECK_LOOP=0.0
      ENDIF

C     AE3(AR_I)=0
C      AE1(AR_I)=0
 999  CONTINUE

      ENDIF


      STOP
      END	
      
      
      































