C
C converts wt.% carbon in enriched austenite, to mole fraction,
C given the alloy composition prior to enrichment, and the wt.%
C carbon following enrichment.
C
      SUBROUTINE MAP_STEEL_ATM(XG,XGM,XBAR,DSI,DMN,DNI,DMO,DCR,
     & DVAN,MSI,MMN,MNI,MMO,MCR,MVAN,MFE)
      IMPLICIT NONE                           
      DOUBLE PRECISION XG,XGM,XBAR,DSI,DMN,DNI,DMO,DCR,DVAN,
     &MSI,MMN,MNI,MMO,MCR,MVAN,MFE,M,BSI,BMN,BNI,BCR,BMO,BVAN,
     &BFE,BC,C,SI,MN,NI,MO,CR,VAN,ASI,AMN,ANI,ACR,AMO,AVAN,
     &AFE,AC,Z,ZSI,ZMN,ZNI,ZMO,ZCR,ZVAN,ZFE,FE
      INTEGER I
C
        I=0
C
C atomic weights
C
        BSI=28.0855
        BMN=54.938
        BNI=58.71
        BCR=51.996
        BMO=95.94
        BVAN=50.94
        BFE=55.847
        BC=12.011
C
C
        C=XBAR
        SI=DSI
        MN=DMN
        NI=DNI
        MO=DMO
        CR=DCR
        VAN=DVAN
C
C Divide wt.% by atomic weights
C
 1       ASI=SI/BSI    
        AMN=MN/BMN
        ANI=NI/BNI
        ACR=CR/BCR
        AMO=MO/BMO
        AVAN=VAN/BVAN
        AFE=FE/BFE
        AC=C/BC
C
C Calculate susbtitutional atom fractions
C
      Z=ASI+AMN+ANI+ACR+AMO+AVAN+AFE
      M=Z+AC
        ZSI=ASI/Z
        ZMN=AMN/Z
        ZNI=ANI/Z
        ZCR=ACR/Z
        ZMO=AMO/Z
        ZVAN=AVAN/Z
        ZFE=AFE/Z
C
        IF(I .GT. 0) GOTO 3
C
C new values allowing for carbon enrichment
C
        SI=ZSI*BSI*(1.0D+02-XG)/BFE
        MN=ZMN*BMN*(1.0D+02-XG)/BFE
        NI=ZNI*BNI*(1.0D+02-XG)/BFE
        MO=ZMO*BMO*(1.0D+02-XG)/BFE
        CR=ZCR*BCR*(1.0D+02-XG)/BFE
        VAN=ZVAN*BVAN*(1.0D+02-XG)/BFE
        FE=ZFE*BFE*(1.0D+02-XG)/BFE
C
      I=2
      C=XG
      GOTO 1
C
C new values of mole fractions
C
3       MSI=ASI/M
        MMN=AMN/M
        MNI=ANI/M
        MCR=ACR/M
        MMO=AMO/M
        MVAN=AVAN/M
C       MCO=ACO/M
        MFE=AFE/M
      XGM=AC/M
C
        RETURN
        END
C
