C  Subroutine  MAP_STEEL_AVOLF
C  S.V. Parker and H.K.D.H. Bhadeshia
C
      SUBROUTINE MAP_STEEL_AVOLF(AREA,ANS,VF,SV,BI,TIME,ETA,ALP1,ZETA,
     &      XBAR,XAGA,XGAG)
C
      IMPLICIT NONE
      DOUBLE PRECISION ALP1,ANS,AREA,ARG,BI,ETA,SV,TIME,VF
      DOUBLE PRECISION XAGA,XBAR,XGAG,ZETA
      DOUBLE PRECISION THETA(51),FUN(51),PHI,PI
      INTEGER IDUM,I
C
      PI = 4D0 * ATAN(1D0)
      PHI=(XGAG-XBAR)/(XGAG-XAGA)
C
      DO 100, I=1,51
         IDUM=I-1
         THETA(I)=IDUM*2.0D-02
         ARG=0.5D0*PI*BI*((ETA*ALP1)**2.0D0)*
     &       (TIME**2.0D0)*(1.0D0 - THETA(I)**4.0D0)
         FUN(I)=1.0D0 - DEXP(-ARG)
 100  CONTINUE
C
      CALL MAP_UTIL_TRAPE(THETA,FUN,ANS,51)
      ARG=2.0D0*SV*ANS*ALP1*(TIME**0.5D0)/PHI
      ZETA=1.0D0 - DEXP(-ARG)
      VF=ZETA*PHI
      AREA = FUN(1)
      RETURN
      END

