C        SUBROUTINE TRAPE
C
C        PURPOSE
C           TO COMPUTE THE VECTOR OF INTEGRAL VALUES FOR A GIVEN
C           GENERAL TABLE OF ARGUMENT AND FUNCTION VALUES.
C
C        USAGE
C             CALL TRAPE (X,Y,Z,NDIM)
C
C        DESCRIPTION OF PARAMETERS
C           X      - DOUBLE PRECISION INPUT VECTOR OF ARGUMENT VALUES.
C           Y      - DOUBLE PRECISION INPUT VECTOR OF FUNCTION VALUES.
C           Z      - THE RESULTING DP. VECTOR OF INTEGRAL VALUES. Z MAY BE
C                    IDENTICAL WITH X OR Y.
C           NDIM   - THE DIMENSION OF VECTORS X,Y,Z. NDIM MAX. 1000
C
C        REMARKS
C           NO ACTION IN CASE NDIM LESS THAN 1.
C
C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED
C           NONE
C
C        METHOD
C           BEGINNING WITH Z(1)=0, EVALUATION OF VECTOR Z IS DONE BY
C           MEANS OF TRAPEZOIDAL RULE (SECOND ORDER FORMULA).
C           FOR REFERENCE, SEE
C           F.B.HILDEBRAND, INTRODUCTION TO NUMERICAL ANALYSIS,
C           MCGRAW-HILL, NEW YORK/TORONTO/LONDON, 1956, PP.75.
C
C       Subroutine stolen from SSP (IBM), cf. PLUS/1000 X019
C           HO    <881109.1345>
C     ..................................................................
C
      SUBROUTINE MAP_UTIL_TRAPE(X,Y,ANS,NDIM)
C
C
      IMPLICIT NONE
      DOUBLE PRECISION X(1000),Y(1000),AZ(1000)
      DOUBLE PRECISION SUM1,SUM2,ANS
      INTEGER NDIM,I
C
      SUM2=0.D+00
      IF(NDIM-1)4,3,1
C
C     INTEGRATION LOOP
    1 DO 2 I=2,NDIM
      SUM1=SUM2
      SUM2=SUM2+.5D+00*(X(I)-X(I-1))*(Y(I)+Y(I-1))
    2 AZ(I-1)=SUM1
    3 AZ(NDIM)=SUM2
      ANS=SUM2
    4 RETURN
      END
